/*
 * Decompiled with CFR 0.152.
 */
package repackaged.com.amazonaws.auth;

import java.io.IOException;
import repackaged.com.amazonaws.annotation.SdkInternalApi;
import repackaged.com.amazonaws.retry.internal.CredentialsEndpointRetryParameters;
import repackaged.com.amazonaws.retry.internal.CredentialsEndpointRetryPolicy;

@SdkInternalApi
class ContainerCredentialsRetryPolicy
implements CredentialsEndpointRetryPolicy {
    private static final int MAX_RETRIES = 5;
    private static ContainerCredentialsRetryPolicy instance;

    private ContainerCredentialsRetryPolicy() {
    }

    public static ContainerCredentialsRetryPolicy getInstance() {
        if (instance == null) {
            instance = new ContainerCredentialsRetryPolicy();
        }
        return instance;
    }

    @Override
    public boolean shouldRetry(int retriesAttempted, CredentialsEndpointRetryParameters retryParams) {
        if (retriesAttempted >= 5) {
            return false;
        }
        Integer statusCode = retryParams.getStatusCode();
        if (statusCode != null && statusCode >= 500 && statusCode < 600) {
            return true;
        }
        return retryParams.getException() != null && retryParams.getException() instanceof IOException;
    }
}

