/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.commons.datevariant;

import io.magentys.commons.datevariant.DateFormatInternal;
import io.magentys.commons.datevariant.DateTypeInternal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadableInstant;

public class DateVariant {
    private DateTime date;
    private String originalDateString;
    private DateTypeInternal.IDateType type;

    public static DateVariant today() {
        return DateVariant.from(new DateTime());
    }

    public static DateVariant todayOffsetBy(DateUnit dateUnit, DateOffset dateOffset, int multiplier) {
        return DateVariant.offsetBy(DateTime.now(), dateUnit, dateOffset, multiplier);
    }

    private static DateVariant offsetBy(DateTime dateTime, DateUnit dateUnit, DateOffset dateOffset, int multiplier) {
        return DateVariant.from(dateTime.withFieldAdded(dateUnit.getInterval(), dateOffset.getOffset(multiplier)));
    }

    public static DateVariant from(String dateIn, DateFormatInternal.IDateFormat format) {
        return new DateVariant(dateIn, format);
    }

    public static DateVariant from(String dateString) {
        return new DateVariant(dateString, null);
    }

    public static DateVariant from(DateTime date) {
        return new DateVariant(date);
    }

    private DateVariant(String dateString, DateFormatInternal.IDateFormat format) {
        this.originalDateString = dateString;
        try {
            this.date = this.parseDate(dateString, format);
        }
        catch (Exception e) {
            this.date = null;
        }
        this.type = this.date != null ? DateTypeInternal.DateType.VALID_DATE : DateTypeInternal.fromLabel(dateString);
    }

    public DateVariant(DateTime date) {
        this.originalDateString = null;
        this.date = date;
        this.type = DateTypeInternal.DateType.VALID_DATE;
    }

    private DateTime parseDate(String dateString, DateFormatInternal.IDateFormat requiredFormat) {
        ArrayList<DateFormatInternal.IDateFormat> formats = new ArrayList<DateFormatInternal.IDateFormat>();
        if (requiredFormat == null) {
            formats = DateFormatInternal.registeredFormats();
            return this.parseDateWithFormats(dateString, formats);
        }
        formats.add(requiredFormat);
        return this.parseDateWithFormats(dateString, formats);
    }

    private DateTime parseDateWithFormats(String dateString, List<DateFormatInternal.IDateFormat> formats) {
        DateFormatInternal.IDateFormat df;
        DateTime date = null;
        Iterator<DateFormatInternal.IDateFormat> iterator = formats.iterator();
        while (iterator.hasNext() && (date = (df = iterator.next()).getDateFormatInternal().stringToDate(dateString)) == null) {
        }
        return date;
    }

    public DateTime getDate() {
        return this.date;
    }

    public String getOriginalDateString() {
        return this.originalDateString;
    }

    public DateTypeInternal.IDateType getType() {
        return this.type;
    }

    public boolean compare(DateVariant other) {
        if (this.type.equals(DateTypeInternal.DateType.VALID_DATE)) {
            return other.type.equals(DateTypeInternal.DateType.VALID_DATE) && this.isSameDay(other);
        }
        if (this.type.equals(DateTypeInternal.DateType.STRING_VALUE)) {
            return other.type.equals(DateTypeInternal.DateType.STRING_VALUE) && this.originalDateString.equals(other.getOriginalDateString());
        }
        return other.type.equals(this.type);
    }

    public String toString(DateFormatInternal.IDateFormat format) {
        return this.type.equals(DateTypeInternal.DateType.VALID_DATE) ? format.getDateFormatInternal().dateToString(this.date) : this.originalDateString;
    }

    public boolean isAfter(DateVariant other) {
        return this.date.isAfter((ReadableInstant)other.getDate());
    }

    public boolean isBefore(DateVariant other) {
        return this.date.isBefore((ReadableInstant)other.getDate());
    }

    public boolean isSameDay(DateVariant other) {
        return this.date.toLocalDate().equals((Object)other.getDate().toLocalDate());
    }

    public boolean isType(DateTypeInternal.IDateType type) {
        return this.getType().equals(type);
    }

    public DateVariant offsetBy(DateUnit dateUnit, DateOffset dateOffset, int days) {
        return DateVariant.offsetBy(this.getDate(), dateUnit, dateOffset, days);
    }

    public int getYear() {
        return this.date.getYear();
    }

    public int getDay() {
        return this.date.getDayOfMonth();
    }

    public String getMonthName() {
        return this.date.monthOfYear().getAsText();
    }

    public static enum DateOffset {
        BEFORE(-1),
        ON(0),
        AFTER(1);

        private int offset;

        private DateOffset(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getOffset(int multiplier) {
            return this.offset * multiplier;
        }

        public static DateOffset getByLabel(String label) {
            for (DateOffset d : DateOffset.values()) {
                if (!d.name().toString().equalsIgnoreCase(label)) continue;
                return d;
            }
            return null;
        }
    }

    public static enum DateUnit {
        DAY(DurationFieldType.days()),
        MONTH(DurationFieldType.months()),
        YEAR(DurationFieldType.years());

        private DurationFieldType interval;

        private DateUnit(DurationFieldType interval) {
            this.interval = interval;
        }

        public DurationFieldType getInterval() {
            return this.interval;
        }
    }
}

