/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.commons.datevariant;

import java.util.ArrayList;
import java.util.List;

public class DateTypeInternal {
    private static List<IDateType> iDateTypeList = new ArrayList<IDateType>();
    private String match;

    public static void register(IDateType iDateType) {
        if (!iDateTypeList.contains(iDateType)) {
            iDateTypeList.add(iDateType);
        }
    }

    public static void deregister(IDateType iDateType) {
        if (iDateTypeList.contains(iDateType)) {
            iDateTypeList.remove(iDateType);
        }
    }

    public static IDateType fromLabel(String label) {
        for (IDateType idt : iDateTypeList) {
            if (!idt.getDateTypeInternal().testMatch(label)) continue;
            return idt;
        }
        return DateType.STRING_VALUE;
    }

    public DateTypeInternal(String match) {
        this.match = match;
    }

    public boolean testMatch(String label) {
        return this.match != null && this.match.equals(label);
    }

    public static enum DateType implements IDateType
    {
        VALID_DATE(null),
        STRING_VALUE(null);

        private DateTypeInternal dateTypeInternal;

        private DateType(String match) {
            this.dateTypeInternal = new DateTypeInternal(match);
            DateTypeInternal.register(this);
        }

        @Override
        public DateTypeInternal getDateTypeInternal() {
            return this.dateTypeInternal;
        }
    }

    public static interface IDateType {
        public DateTypeInternal getDateTypeInternal();
    }
}

