/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.commons.datevariant;

import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateFormatInternal {
    private static List<IDateFormat> iDateFormatList = new ArrayList<IDateFormat>();
    private String format;
    private DateTimeFormatter dtf;

    public static void register(IDateFormat iDateFormat) {
        if (!iDateFormatList.contains(iDateFormat)) {
            iDateFormatList.add(iDateFormat);
        }
    }

    public static void deregister(IDateFormat iDateFormat) {
        if (iDateFormatList.contains(iDateFormat)) {
            iDateFormatList.remove(iDateFormat);
        }
    }

    public static List<IDateFormat> registeredFormats() {
        ArrayList<IDateFormat> formats = new ArrayList<IDateFormat>();
        formats.addAll(iDateFormatList);
        return formats;
    }

    public DateFormatInternal(String format) {
        this.format = format;
        this.dtf = DateTimeFormat.forPattern((String)format);
    }

    public String getFormat() {
        return this.format;
    }

    public DateTimeFormatter getDtf() {
        return this.dtf;
    }

    public String dateToString(DateTime date) {
        return date.toString(this.dtf);
    }

    public DateTime stringToDate(String dateString) {
        try {
            return this.dtf.parseDateTime(dateString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static interface IDateFormat {
        public DateFormatInternal getDateFormatInternal();
    }
}

