/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.commons.adapt.string;

import io.magentys.commons.adapt.string.CsvAdapter;
import io.magentys.commons.adapt.string.IdentityAdapter;
import io.magentys.commons.adapt.string.IntegerAdapter;
import io.magentys.commons.adapt.string.JsonAdapter;
import io.magentys.commons.adapt.string.JsonListAdapter;
import io.magentys.commons.adapt.string.ListAdapter;
import io.magentys.commons.adapt.string.MapAdapter;
import java.util.List;
import java.util.Map;

public final class StringAdapters {
    public static StringAdapter<String> string() {
        return new IdentityAdapter();
    }

    public static StringAdapter<List<String>> csv() {
        return new CsvAdapter();
    }

    public static StringAdapter<Integer> integer() {
        return new IntegerAdapter();
    }

    public static <X> ListAdapter<X> csvOf(StringAdapter<X> ofType) {
        return new ListAdapter<X>(StringAdapters.csv(), ofType);
    }

    public static <X> ListAdapter<X> listOf(StringAdapter<List<String>> strings, StringAdapter<X> ofType) {
        return new ListAdapter<X>(strings, ofType);
    }

    public static StringAdapter<Map<String, String>> map() {
        return new MapAdapter<String>(StringAdapters.csv(), StringAdapters.string());
    }

    public static <X> StringAdapter<Map<String, X>> mapOf(StringAdapter<X> values) {
        return new MapAdapter<X>(StringAdapters.csv(), values);
    }

    public static <T> StringAdapter<T> jsonOf(Class<T> type) {
        return new JsonAdapter<T>(type);
    }

    public static <T> StringAdapter<List<T>> jsonListOf(Class<T> type) {
        return JsonListAdapter.of(type);
    }

    public static interface StringAdapter<T> {
        public String toString(T var1);

        public T fromString(String var1);
    }
}

