/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.commons.adapt.string;

import io.magentys.commons.adapt.string.StringAdapters;
import java.util.Map;
import org.apache.commons.collections.keyvalue.DefaultMapEntry;

public class MapEntryAdapter<X>
implements StringAdapters.StringAdapter<Map.Entry<String, X>> {
    private final StringAdapters.StringAdapter<X> valueAdapter;

    public MapEntryAdapter(StringAdapters.StringAdapter<X> valueAdapter) {
        this.valueAdapter = valueAdapter;
    }

    @Override
    public String toString(Map.Entry<String, X> t) {
        return t.getKey() + ":" + this.valueAdapter.toString(t.getValue());
    }

    @Override
    public Map.Entry<String, X> fromString(String s) {
        String value;
        if (s == null || s.isEmpty() || !s.contains(":")) {
            throw new IllegalArgumentException("expected <key>:<value>. Got: " + s);
        }
        String[] keyValuePair = s.split(":");
        if (keyValuePair.length != 1 && keyValuePair.length != 2) {
            throw new IllegalArgumentException("expected <key>:<value>. Got: " + s);
        }
        String key = keyValuePair[0].trim();
        String string = value = keyValuePair.length == 2 ? keyValuePair[1].trim() : "";
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key must be defined. expected <key>:<value>. Got: " + s);
        }
        return new DefaultMapEntry((Object)key, this.valueAdapter.fromString(value));
    }
}

