/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.commons.adapt.string;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.magentys.commons.adapt.string.StringAdapters;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class JsonListAdapter<T>
implements StringAdapters.StringAdapter<List<T>> {
    private final Type collectionType;
    private final Gson json = new GsonBuilder().create();

    private JsonListAdapter(Type collectionType) {
        this.collectionType = collectionType;
    }

    @Override
    public String toString(List<T> t) {
        return this.json.toJson(t);
    }

    @Override
    public List<T> fromString(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        JsonArray jsonArray = new JsonParser().parse(s).getAsJsonArray();
        LinkedList<Object> deserialised = new LinkedList<Object>();
        for (JsonElement jsonElement : jsonArray) {
            Object fromJson = this.json.fromJson(jsonElement, this.collectionType);
            deserialised.add(fromJson);
        }
        return deserialised;
    }

    public static <T> JsonListAdapter<T> of(Class<T> type) {
        Class<T> collectionType = type;
        return new JsonListAdapter<T>(collectionType);
    }
}

