/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.commons.adapt.string;

import io.magentys.commons.adapt.string.StringAdapters;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class CsvAdapter
implements StringAdapters.StringAdapter<List<String>> {
    private static final String CSV_REGEX = " *, *";

    CsvAdapter() {
    }

    @Override
    public String toString(List<String> t) {
        if (t == null || t.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String string : t) {
            sb.append(string.trim()).append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public List<String> fromString(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(s.trim().split(CSV_REGEX));
    }
}

