/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cinnamon.webdriver.factory;

import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.util.Try$;

public final class DriverRegistry$ {
    public static final DriverRegistry$ MODULE$;
    private final scala.collection.mutable.Map<String, Map<String, Object>> driverClassToCapabilities;

    static {
        new DriverRegistry$();
    }

    private scala.collection.mutable.Map<String, Map<String, Object>> driverClassToCapabilities() {
        return this.driverClassToCapabilities;
    }

    public Option<Class<? extends WebDriver>> getDriverClass(DesiredCapabilities capabilities) {
        Iterable driverClassNames = ((MapLike)this.driverClassToCapabilities().filter((Function1)new Serializable(capabilities){
            public static final long serialVersionUID = 0L;
            private final DesiredCapabilities capabilities$1;

            public final boolean apply(Tuple2<String, Map<String, Object>> p) {
                return this.capabilities$1.asMap().entrySet().containsAll(((Map)p._2()).entrySet());
            }
            {
                this.capabilities$1 = capabilities$1;
            }
        })).keys();
        return Try$.MODULE$.apply((Function0)new Serializable(driverClassNames){
            public static final long serialVersionUID = 0L;
            private final Iterable driverClassNames$1;

            public final Class<WebDriver> apply() {
                return Class.forName((String)this.driverClassNames$1.head()).asSubclass(WebDriver.class);
            }
            {
                this.driverClassNames$1 = driverClassNames$1;
            }
        }).toOption();
    }

    public Option<Class<? extends RemoteWebDriver>> getRemoteDriverClass(DesiredCapabilities capabilities) {
        Object object = capabilities.getCapability("platformName");
        Option option = "Android".equals(object) ? Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<RemoteWebDriver> apply() {
                return Class.forName("io.appium.java_client.android.AndroidDriver").asSubclass(RemoteWebDriver.class);
            }
        }).toOption() : ("iOS".equals(object) ? Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<RemoteWebDriver> apply() {
                return Class.forName("io.appium.java_client.ios.IOSDriver").asSubclass(RemoteWebDriver.class);
            }
        }).toOption() : Try$.MODULE$.apply((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Class<RemoteWebDriver> apply() {
                return Class.forName("org.openqa.selenium.remote.RemoteWebDriver").asSubclass(RemoteWebDriver.class);
            }
        }).toOption());
        return option;
    }

    public void registerDriverClass(String driverClass, Map<String, Object> capabilitiesMatcher) {
        Predef$.MODULE$.require(!this.driverClassToCapabilities().contains((Object)driverClass), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The driver class has already been registered."})).s((Seq)Nil$.MODULE$);
            }
        });
        this.driverClassToCapabilities().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)driverClass), capabilitiesMatcher));
    }

    private DriverRegistry$() {
        MODULE$ = this;
        this.driverClassToCapabilities = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.openqa.selenium.chrome.ChromeDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("browserName", "chrome");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.openqa.selenium.firefox.FirefoxDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("browserName", "firefox");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.openqa.selenium.ie.InternetExplorerDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("browserName", "internet explorer");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.openqa.selenium.edge.EdgeDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("browserName", "MicrosoftEdge");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.openqa.selenium.opera.OperaDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("browserName", "operablink");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.openqa.selenium.safari.SafariDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("browserName", "safari");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.openqa.selenium.phantomjs.PhantomJSDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("browserName", "phantomjs");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.openqa.selenium.htmlunit.HtmlUnitDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("browserName", "htmlunit");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"io.appium.java_client.android.AndroidDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("platformName", "Android");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"io.appium.java_client.ios.IOSDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("platformName", "iOS");
            }
        }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"io.appium.java_client.windows.WindowsDriver"), (Object)new HashMap<String, Object>(){
            {
                this.put("platformName", "Windows");
            }
        })}));
    }
}

