/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cinnamon.cucumber;

import cucumber.runtime.junit.ExecutionUnitRunner;
import cucumber.runtime.junit.FeatureRunner;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Result;
import io.magentys.cinnamon.cucumber.events.AfterHooksFinishedEvent;
import io.magentys.cinnamon.cucumber.events.CucumberFinishedEvent;
import io.magentys.cinnamon.cucumber.events.ScenarioFinishedEvent;
import io.magentys.cinnamon.cucumber.events.StepFinishedEvent;
import io.magentys.cinnamon.eventbus.EventBusContainer;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;

@Aspect
public class CucumberAspect {
    private static final ThreadLocal<String> featureName = new ThreadLocal();
    private static final ThreadLocal<String> scenarioName = new ThreadLocal();
    private static final ThreadLocal<Reporter> reporter = new ThreadLocal();
    private static final ThreadLocal<List<Result>> results = new ThreadLocal();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ CucumberAspect ajc$perSingletonInstance;

    static {
        try {
            CucumberAspect.ajc$perSingletonInstance = new CucumberAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(public * cucumber.api.junit.Cucumber.run(..))")
    public /* synthetic */ void runCucumber() {
    }

    @Pointcut(value="execution(public * cucumber.runtime.junit.FeatureRunner.run(..))")
    public /* synthetic */ void runFeature() {
    }

    @Pointcut(value="execution(public * cucumber.runtime.junit.ExecutionUnitRunner.run(..))")
    public /* synthetic */ void runScenario() {
    }

    @Pointcut(value="execution(public void cucumber.runtime.Runtime.buildBackendWorlds(..))")
    public /* synthetic */ void buildBackendWorlds() {
    }

    @Pointcut(value="execution(public void cucumber.runtime.Runtime.runBeforeHooks(..))")
    public /* synthetic */ void runBeforeHooks() {
    }

    @Pointcut(value="execution(public void cucumber.runtime.Runtime.runStep(..))")
    public /* synthetic */ void runStep() {
    }

    @Pointcut(value="execution(* cucumber.runtime.Runtime.addStepToCounterAndResult(..))")
    public /* synthetic */ void addStepToCounterAndResult() {
    }

    @Pointcut(value="execution(public void cucumber.runtime.Runtime.runAfterHooks(..))")
    public /* synthetic */ void runAfterHooks() {
    }

    @Pointcut(value="execution(public void cucumber.runtime.Runtime.disposeBackendWorlds(..))")
    public /* synthetic */ void disposeBackendWorlds() {
    }

    @Before(value="runFeature()")
    public void beforeRunFeature(JoinPoint joinPoint) {
        FeatureRunner featureRunner = (FeatureRunner)((Object)joinPoint.getTarget());
        featureName.set(featureRunner.getName());
    }

    @Before(value="runScenario()")
    public void beforeRunScenario(JoinPoint joinPoint) {
        ExecutionUnitRunner executionUnitRunner = (ExecutionUnitRunner)((Object)joinPoint.getTarget());
        scenarioName.set(executionUnitRunner.getName());
    }

    @Before(value="buildBackendWorlds() && args(reporter,..)")
    public void beforeBuildBackendWorlds(Reporter reporter) {
        CucumberAspect.reporter.set(reporter);
    }

    @After(value="buildBackendWorlds()")
    public void afterBuildBackendWorlds() {
        results.set(new ArrayList());
    }

    @After(value="addStepToCounterAndResult() && args(result,..)")
    public void afterAddStepToCounterAndResult(Result result) {
        results.get().add(result);
        EventBusContainer.getEventBus().post((Object)new StepFinishedEvent(result, reporter.get()));
    }

    @After(value="runAfterHooks()")
    public void afterRunAfterHooks() {
        EventBusContainer.getEventBus().post((Object)new AfterHooksFinishedEvent());
    }

    @After(value="disposeBackendWorlds()")
    public void afterDisposeBackendWorlds() {
        EventBusContainer.getEventBus().post((Object)new ScenarioFinishedEvent(results.get()));
    }

    @After(value="runCucumber()")
    public void afterRunCucumber() {
        try {
            EventBusContainer.getEventBus().post((Object)new CucumberFinishedEvent());
        }
        finally {
            reporter.remove();
            results.remove();
            scenarioName.remove();
            featureName.remove();
        }
    }

    public static CucumberAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("io.magentys.cinnamon.cucumber.CucumberAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

