/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.junit.ExecutionUnitRunner;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.junit.ScenarioOutlineRunner;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.CucumberScenario;
import cucumber.runtime.model.CucumberScenarioOutline;
import cucumber.runtime.model.CucumberTagStatement;
import gherkin.formatter.model.Feature;
import io.magentys.cinnamon.cucumber.CucumberAspect;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class FeatureRunner
extends ParentRunner<ParentRunner> {
    private final List<ParentRunner> children = new ArrayList<ParentRunner>();
    private final CucumberFeature cucumberFeature;
    private final Runtime runtime;
    private final JUnitReporter jUnitReporter;
    private Description description;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public FeatureRunner(CucumberFeature cucumberFeature, Runtime runtime, JUnitReporter jUnitReporter) throws InitializationError {
        super(null);
        this.cucumberFeature = cucumberFeature;
        this.runtime = runtime;
        this.jUnitReporter = jUnitReporter;
        this.buildFeatureElementRunners();
    }

    public String getName() {
        Feature feature = this.cucumberFeature.getGherkinFeature();
        return feature.getKeyword() + ": " + feature.getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)this.cucumberFeature.getGherkinFeature(), (Annotation[])new Annotation[0]);
            for (ParentRunner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    protected List<ParentRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(ParentRunner child) {
        return child.getDescription();
    }

    protected void runChild(ParentRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    public void run(RunNotifier notifier) {
        RunNotifier runNotifier = notifier;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)runNotifier);
        CucumberAspect.aspectOf().beforeRunFeature(joinPoint);
        this.jUnitReporter.uri(this.cucumberFeature.getPath());
        this.jUnitReporter.feature(this.cucumberFeature.getGherkinFeature());
        super.run(notifier);
        this.jUnitReporter.eof();
    }

    private void buildFeatureElementRunners() {
        for (CucumberTagStatement cucumberTagStatement : this.cucumberFeature.getFeatureElements()) {
            try {
                Object featureElementRunner = cucumberTagStatement instanceof CucumberScenario ? new ExecutionUnitRunner(this.runtime, (CucumberScenario)cucumberTagStatement, this.jUnitReporter) : new ScenarioOutlineRunner(this.runtime, (CucumberScenarioOutline)cucumberTagStatement, this.jUnitReporter);
                this.children.add((ParentRunner)featureElementRunner);
            }
            catch (InitializationError e) {
                throw new CucumberException("Failed to create scenario runner", e);
            }
        }
    }

    static {
        FeatureRunner.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("FeatureRunner.java", FeatureRunner.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "cucumber.runtime.junit.FeatureRunner", "org.junit.runner.notification.RunNotifier", "notifier", "", "void"), 68);
    }
}

