/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cinnamon.converter;

import io.magentys.cinnamon.converter.Converter;
import java.lang.reflect.Field;
import java.util.Map;

public class MapToObjectReflectionConverter<T>
implements Converter<Map<String, String>, T> {
    private final Class<T> type;

    public MapToObjectReflectionConverter(Class<T> type) {
        this.type = type;
    }

    @Override
    public T convert(Map<String, String> source) {
        try {
            T mappedType = this.type.newInstance();
            for (Map.Entry<String, String> entry : source.entrySet()) {
                try {
                    Field fieldName = this.type.getDeclaredField(entry.getKey());
                    fieldName.setAccessible(true);
                    fieldName.set(mappedType, entry.getValue());
                }
                catch (NoSuchFieldException fieldName) {
                }
                catch (SecurityException e) {
                    throw new AssertionError("Failed to populate type: " + this.type, e);
                }
            }
            return mappedType;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(this.type.getClass().getName() + " should have a public no-arguments constructor.", e);
        }
    }
}

