/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cinnamon.conf;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import io.magentys.cinnamon.conf.ConfigConstants;
import java.io.File;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Env {
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    public static final Env INSTANCE = new Env(ConfigConstants.ENV_PROPERTY);
    private String env;
    public Config config;

    public static Env env() {
        return INSTANCE;
    }

    public Env(String env) {
        Optional<String> param = Optional.ofNullable(env);
        if (!param.isPresent()) {
            throw new RuntimeException("Cannot initialise Env. Please provide env profile parameter (-Denv=myProfile)");
        }
        this.env = env;
        this.config = this.initConfig();
    }

    private Config initConfig() {
        Config systemConfig = ConfigFactory.systemProperties();
        File envConfig = this.searchConfigFileInClasspath("env.conf");
        return systemConfig.withFallback((ConfigMergeable)ConfigFactory.parseFile((File)envConfig)).resolve().getConfig(this.env);
    }

    private File searchConfigFileInClasspath(String filename) {
        Stream<File> streamFiles = new ArrayList(FileUtils.listFiles((File)new File(ConfigConstants.PROJECT_DIR), (IOFileFilter)new RegexFileFilter(filename), (IOFileFilter)TrueFileFilter.INSTANCE)).stream().filter(f -> !f.getAbsolutePath().contains("target"));
        ArrayList files = new ArrayList();
        streamFiles.forEach(files::add);
        if (files.size() == 0) {
            throw new Error("Config file with name [" + filename + "] could not be found in your classpath.");
        }
        if (files.size() > 1) {
            this.log.warn("More than one file found for this environment with name [" + filename + "]");
        }
        if (!((File)files.get(0)).isFile()) {
            throw new Error("The file [" + ((File)files.get(0)).getAbsolutePath() + "] is not a normal file.");
        }
        return (File)files.get(0);
    }
}

