/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cinnamon.guice;

import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.magentys.cinnamon.guice.CinnamonModule;
import io.magentys.cinnamon.guice.OverridesModule;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;
import org.reflections.Reflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceModuleAggregator {
    private final List<Class<? extends Annotation>> moduleAnnotations;
    private final List<Class<? extends Annotation>> overridesModuleAnnotations;
    private final List<String> packages;

    public GuiceModuleAggregator(Builder builder) {
        this.moduleAnnotations = builder.moduleAnnotations;
        this.overridesModuleAnnotations = builder.overridesModuleAnnotations;
        this.packages = builder.packages;
    }

    public List<Class<? extends Annotation>> getModuleAnnotations() {
        return this.moduleAnnotations;
    }

    public List<Class<? extends Annotation>> getOverridesModuleAnnotations() {
        return this.overridesModuleAnnotations;
    }

    public List<String> getPackages() {
        return this.packages;
    }

    public static class Builder {
        private static final String GUICE_PACKAGE = "com.google.inject";
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private List<Class<? extends Annotation>> moduleAnnotations = new ArrayList<Class<? extends Annotation>>();
        private List<Class<? extends Annotation>> overridesModuleAnnotations = new ArrayList<Class<OverridesModule>>(Collections.singletonList(OverridesModule.class));
        private List<String> packages = new ArrayList<String>();

        public Builder withModuleAnnotations(Class<? extends Annotation> ... moduleAnnotations) {
            this.moduleAnnotations = new ArrayList<Class<? extends Annotation>>(Arrays.asList(moduleAnnotations));
            return this;
        }

        public Builder withOverrideModuleAnnotations(Class<? extends Annotation> ... overridesModuleAnnotations) {
            this.overridesModuleAnnotations = new ArrayList<Class<? extends Annotation>>(Arrays.asList(overridesModuleAnnotations));
            return this;
        }

        public Builder withPackages(String ... packages) {
            this.packages = new ArrayList<String>(Arrays.asList(packages));
            return this;
        }

        public Module build() {
            try {
                Map<String, Module> modules = this.getModulesAnnotatedWith(this.moduleAnnotations);
                Map<String, Module> overridesModules = this.getModulesAnnotatedWith(this.overridesModuleAnnotations);
                modules = modules.isEmpty() ? this.getSubTypesOfModule() : modules;
                this.logger.debug("Modules [" + Collections.singletonList(modules.keySet()) + "]");
                this.logger.debug("Overrides modules [" + (overridesModules.isEmpty() ? "" : Collections.singletonList(overridesModules.keySet())) + "]");
                return overridesModules.isEmpty() ? Modules.combine(modules.values()) : Modules.override(modules.values()).with(overridesModules.values());
            }
            catch (FileSystemException e) {
                this.logger.error(e.getMessage());
                return null;
            }
        }

        private Map<String, Module> getModulesAnnotatedWith(List<Class<? extends Annotation>> annotations) throws FileSystemException {
            HashMap<String, Module> modules = new HashMap<String, Module>();
            this.packages = this.packages.isEmpty() ? this.getPackages() : this.packages;
            Reflections reflections = new Reflections(new Object[]{this.packages});
            for (Class<? extends Annotation> annotation : annotations) {
                reflections.getTypesAnnotatedWith(annotation).stream().filter(Module.class::isAssignableFrom).forEachOrdered(clazz -> {
                    try {
                        Module instance = (Module)clazz.newInstance();
                        if (!modules.containsKey(clazz.getName())) {
                            modules.put(clazz.getName(), instance);
                        }
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        this.logger.error(e.getMessage());
                    }
                });
            }
            return modules;
        }

        private Map<String, Module> getSubTypesOfModule() throws FileSystemException {
            HashMap<String, Module> modules = new HashMap<String, Module>();
            this.packages = this.packages.isEmpty() ? this.getPackages() : this.packages;
            Reflections reflections = new Reflections(new Object[]{this.packages, GUICE_PACKAGE});
            reflections.getSubTypesOf(Module.class).stream().filter(module -> !this.hasOverridesAnnotation((Class<? extends Module>)module) && !module.getName().startsWith(GUICE_PACKAGE) && !module.getName().equals(CinnamonModule.class.getName())).forEachOrdered(module -> {
                try {
                    Module instance = (Module)module.newInstance();
                    if (!modules.containsKey(module.getName())) {
                        modules.put(module.getName(), instance);
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    this.logger.error(e.getMessage());
                }
            });
            return modules;
        }

        private boolean hasOverridesAnnotation(Class<? extends Module> module) {
            for (Class<? extends Annotation> annotation : this.overridesModuleAnnotations) {
                if (!module.isAnnotationPresent(annotation)) continue;
                return true;
            }
            return false;
        }

        private List<String> getPackages() throws FileSystemException {
            FileSystemManager fileSystemManager = VFS.getManager();
            HashSet<String> packageNames = new HashSet<String>();
            for (String element : System.getProperty("java.class.path").split(";")) {
                FileObject fileObject;
                if (element.endsWith("jar")) {
                    fileObject = fileSystemManager.resolveFile("jar://" + element);
                    this.addPackages(fileObject, "", packageNames);
                    continue;
                }
                fileObject = fileSystemManager.resolveFile(element);
                if (fileObject.getType() != FileType.FOLDER) continue;
                this.addPackages(fileObject, fileObject.getName().getPath(), packageNames);
            }
            return new ArrayList<String>(packageNames);
        }

        private void addPackages(FileObject fileObject, String filePath, HashSet<String> packageNames) throws FileSystemException {
            for (FileObject child : fileObject.getChildren()) {
                if (child.getName().getBaseName().equals("META-INF")) continue;
                if (child.getType() == FileType.FOLDER) {
                    this.addPackages(child, filePath, packageNames);
                    continue;
                }
                if (!child.getName().getExtension().equals("class")) continue;
                String parentPath = child.getParent().getName().getPath();
                parentPath = StringUtils.remove((String)parentPath, (String)filePath);
                parentPath = StringUtils.removeStart((String)parentPath, (String)"/");
                parentPath = parentPath.replaceAll("/", ".");
                packageNames.add(parentPath);
            }
        }
    }
}

