/*
 * Decompiled with CFR 0.152.
 */
package io.magentys;

import io.magentys.Memory;
import io.magentys.Mission;
import io.magentys.Narrator;
import io.magentys.annotations.Narrate;
import io.magentys.exceptions.NotAvailableException;
import io.magentys.utils.Any;
import io.magentys.utils.Clazz;
import io.magentys.utils.Requires;
import io.magentys.utils.UniqueId;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Agent {
    protected Memory memory;
    protected List<Any> tools = new ArrayList<Any>();
    protected String name = UniqueId.incrementalId();
    protected Set<Narrator> narrators = new HashSet<Narrator>();

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<Narrator> getNarrators() {
        return this.narrators;
    }

    public Agent(Memory memory) {
        this.memory = memory;
    }

    public void setMemory(Memory mem) {
        this.memory = mem;
    }

    public <RESULT> RESULT performs(Mission<RESULT> mission) {
        this.narrateBefore(mission);
        RESULT result = mission.accomplishAs(this);
        this.narrateAfter(mission);
        return result;
    }

    protected <RESULT> void narrateBefore(Mission<RESULT> mission) {
        if (mission.getClass().isAnnotationPresent(Narrate.class)) {
            Narrate narrate = mission.getClass().getAnnotation(Narrate.class);
            this.narrateThat(narrate.value());
        }
    }

    protected <RESULT> void narrateAfter(Mission<RESULT> mission) {
        Narrate narrate;
        if (mission.getClass().isAnnotationPresent(Narrate.class) && !"".equals((narrate = mission.getClass().getAnnotation(Narrate.class)).after()) && narrate.after() != null) {
            this.narrateThat(narrate.after());
        }
    }

    public void narrateThat(String message) {
        for (Narrator narrator : this.narrators) {
            narrator.narrate(this.name, "info", message);
        }
    }

    public void narrateThat(String level, String message) {
        for (Narrator narrator : this.narrators) {
            narrator.narrate(this.name, "info", message);
        }
    }

    public Agent performAll(Mission ... missions) {
        Requires.requires(missions != null && missions.length > 0, "No Missions were passed");
        for (Mission mission : missions) {
            this.performs(mission);
        }
        return this;
    }

    public Agent obtains(Object ... tools) {
        Requires.requiresNotNull(tools, "tools were empty");
        for (Object tool : tools) {
            this.tools.add(Any.any(tool));
        }
        return this;
    }

    public Agent reportsUsing(Narrator ... narrators) {
        Requires.requiresNotNull(narrators, "narrators were null");
        for (Narrator narrator : narrators) {
            this.narrators.add(narrator);
        }
        return this;
    }

    public Agent setTools(List<Any> tools) {
        this.tools = tools;
        return this;
    }

    public Agent setNarrators(Set<Narrator> narrators) {
        this.narrators = narrators;
        return this;
    }

    public <TOOL> TOOL usingThe(Class<TOOL> toolClass) {
        for (Any tool : this.tools) {
            if (!Clazz.isClassOrSubclass(toolClass, tool.get().getClass())) continue;
            return (TOOL)tool.get();
        }
        throw new NotAvailableException("I don't know this skill: " + toolClass);
    }

    public <VALUE> void keepsInMind(String key, VALUE value) {
        this.memory.remember(key, value);
    }

    public <VALUE> VALUE recalls(String key, Class<VALUE> clazz) {
        return this.memory.recall(key, clazz);
    }

    public <T> T and(Mission<T> mission) {
        return mission.accomplishAs(this);
    }

    public <T> T andHe(Mission<T> mission) {
        return this.and(mission);
    }

    public <T> T andShe(Mission<T> mission) {
        return this.and(mission);
    }

    public List<Any> getTools() {
        return this.tools;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public Agent addNarrators(Narrator ... narrators) {
        Requires.requiresNotNull(narrators, "Narrators passed were null");
        for (Narrator narrator : narrators) {
            Requires.requiresNotNull(narrator, "narrator was null");
            this.narrators.add(narrator);
        }
        return this;
    }

    public Agent clone() {
        return new Agent(this.memory).setTools(this.tools).setNarrators(this.narrators);
    }

    public <KEY> Agent askThe(Agent anotherAgent, KEY key) {
        anotherAgent.getMemory().transferTo(this.memory, key);
        return this;
    }
}

