/*
 * Decompiled with CFR 0.152.
 */
package io.magentys;

import io.magentys.Memory;
import io.magentys.Mission;
import io.magentys.exceptions.NotAvailableException;
import io.magentys.utils.Any;
import io.magentys.utils.Clazz;
import io.magentys.utils.Requires;
import java.util.ArrayList;
import java.util.List;

public class Agent {
    protected Memory memory;
    protected List<Any> tools = new ArrayList<Any>();

    public Agent(Memory memory) {
        this.memory = memory;
    }

    protected void setMemory(Memory mem) {
        this.memory = mem;
    }

    public <RESULT> RESULT performs(Mission<RESULT> mission) {
        return mission.accomplishAs(this);
    }

    public Agent performAll(Mission ... missions) {
        Requires.requires(missions != null && missions.length > 0, "No Missions were passed");
        for (Mission mission : missions) {
            mission.accomplishAs(this);
        }
        return this;
    }

    public Agent obtains(Object ... tools) {
        Requires.requiresNotNull(tools, "tools were empty");
        for (Object tool : tools) {
            this.tools.add(Any.any(tool));
        }
        return this;
    }

    protected Agent setTools(List<Any> tools) {
        this.tools = tools;
        return this;
    }

    public <TOOL> TOOL usingThe(Class<TOOL> toolClass) {
        for (Any tool : this.tools) {
            if (!Clazz.isClassOrSubclass(toolClass, tool.get().getClass())) continue;
            return (TOOL)tool.get();
        }
        throw new NotAvailableException("I don't know this skill: " + toolClass);
    }

    public <VALUE> void keepsInMind(String key, VALUE value) {
        this.memory.remember(key, value);
    }

    public <VALUE> VALUE recalls(String key, Class<VALUE> clazz) {
        return this.memory.recall(key, clazz);
    }

    public Agent and(Mission mission) {
        this.performAll(mission);
        return this;
    }

    public Agent andHe(Mission ... missions) {
        return this.performAll(missions);
    }

    public Agent andShe(Mission ... missions) {
        return this.performAll(missions);
    }

    public List<Any> getTools() {
        return this.tools;
    }

    public Memory getMemory() {
        return this.memory;
    }

    public Agent clone() {
        return new Agent(this.memory).setTools(this.tools);
    }

    public <KEY> Agent askThe(Agent anotherAgent, KEY key) {
        anotherAgent.getMemory().transferTo(this.memory, key);
        return this;
    }
}

