/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.screens;

import io.magentys.exceptions.ScreenException;
import io.magentys.screens.Screen;
import io.magentys.screens.annotations.ScreenElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public abstract class ScreenFactory {
    public <T extends Screen> T init(T screen) {
        Field[] fields;
        for (Field field : fields = screen.getClass().getFields()) {
            try {
                this.instantiateAndRemember(screen, field);
            }
            catch (IllegalAccessException e) {
                throw new ScreenException("I wasn't able to instantiate your " + screen.getClass() + ". Issue is:\n" + e.getMessage());
            }
        }
        return screen;
    }

    protected abstract <T extends Screen> void instantiateAndRemember(T var1, Field var2) throws IllegalAccessException;

    protected static boolean isElement(Field field) {
        List<Class<?>> interfaces = Arrays.asList(field.getType().getInterfaces());
        return interfaces.contains(ScreenElement.class);
    }
}

