/*
 * Decompiled with CFR 0.152.
 */
package io.magentys;

import io.magentys.Memory;
import io.magentys.Mission;
import io.magentys.exceptions.NotAvailableException;
import io.magentys.utils.Any;
import io.magentys.utils.Clazz;
import io.magentys.utils.Requires;
import java.util.ArrayList;
import java.util.List;

public class Agent {
    private final Memory memory;
    private final List<Any> tools = new ArrayList<Any>();

    public Agent(Memory memory) {
        this.memory = memory;
    }

    public static Agent withMemory(Memory mem) {
        return new Agent(mem);
    }

    public <RESULT> RESULT performs(Mission<RESULT> mission) {
        return mission.accomplishAs(this);
    }

    public Agent performAll(Mission ... missions) {
        Requires.requires(missions != null && missions.length > 0, "No Missions were passed");
        for (Mission mission : missions) {
            mission.accomplishAs(this);
        }
        return this;
    }

    public <TOOL> Agent obtains(TOOL ... tools) {
        for (TOOL tool : tools) {
            this.tools.add(Any.any(tool));
        }
        return this;
    }

    public <TOOL> TOOL usingThe(Class<TOOL> toolClass) {
        for (Any tool : this.tools) {
            if (!Clazz.isClassOrSubclass(toolClass, tool.get().getClass())) continue;
            return (TOOL)tool.get();
        }
        throw new NotAvailableException("I don't know this skill: " + toolClass);
    }

    public <VALUE> void keepsInMind(String key, VALUE value) {
        this.memory.remember(key, value);
    }

    public <VALUE> VALUE recalls(String key, Class<VALUE> clazz) {
        return this.memory.recall(key, clazz);
    }

    public Agent and(Mission mission) {
        this.performAll(mission);
        return this;
    }

    public Agent andHe(Mission ... missions) {
        return this.performAll(missions);
    }

    public Agent andShe(Mission ... missions) {
        return this.performAll(missions);
    }
}

