/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cherry.reactive.events;

import io.magentys.Agent;
import io.magentys.Mission;
import io.magentys.cherry.reactive.events.CherryEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiMissionEvent
implements CherryEvent<Agent, List<Mission>> {
    private final String name;
    private final Agent agent;
    private final List<Mission> metadata;

    public MultiMissionEvent(String name, Agent agent) {
        this.name = name;
        this.agent = agent;
        this.metadata = new ArrayList<Mission>();
    }

    public MultiMissionEvent(String name, Agent agent, Mission ... missions) {
        this.name = name;
        this.agent = agent;
        this.metadata = Arrays.asList(missions);
    }

    public static MultiMissionEvent eventOf(String name, Agent agent) {
        return new MultiMissionEvent(name, agent);
    }

    public static MultiMissionEvent eventOf(String name, Agent agent, Mission ... missions) {
        return new MultiMissionEvent(name, agent, missions);
    }

    @Override
    public Agent body() {
        return this.agent;
    }

    public Agent agent() {
        return this.agent;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public List<Mission> metadata() {
        return this.metadata;
    }

    public List<Mission> missions() {
        return this.metadata();
    }
}

