/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cherry.reactive;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.pattern.Patterns;
import akka.util.Timeout;
import io.magentys.Agent;
import io.magentys.CoreMemory;
import io.magentys.Memory;
import io.magentys.cherry.reactive.MissionStrategy;
import io.magentys.cherry.reactive.ReactiveMission;
import io.magentys.cherry.reactive.actors.CherryActor;
import io.magentys.cherry.reactive.actors.Supervisor;
import io.magentys.cherry.reactive.common.Either;
import io.magentys.cherry.reactive.events.ReactiveMissionEvent;
import io.magentys.cherry.reactive.exceptions.StrategyException;
import io.magentys.cherry.reactive.models.Failure;
import io.magentys.java8.FunctionalAgent;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class ReactiveAgent
extends FunctionalAgent {
    protected static ActorSystem system;
    private ActorRef slave;
    private Boolean failed = false;
    private Failure failure = Failure.empty();
    private ActorRef master;
    private MissionStrategy defaultStrategy;
    private final FiniteDuration defaultTerminationTimeout = Duration.create((long)30L, (TimeUnit)TimeUnit.SECONDS);
    private final FiniteDuration timeout = Duration.create((long)1L, (TimeUnit)TimeUnit.SECONDS);

    public ReactiveAgent(Memory memory) throws Exception {
        super(memory);
        this.initializeActorSystem();
    }

    private void initializeActorSystem() throws Exception {
        system = ActorSystem.create((String)(this.name() + "-System"));
        this.master = system.actorOf(Props.create(Supervisor.class, (Object[])new Object[0]), this.name());
        this.slave = (ActorRef)Await.result((Awaitable)Patterns.ask((ActorRef)this.master, (Object)Props.create(CherryActor.class, (Object[])new Object[0]), (long)5000L), (Duration)this.timeout);
    }

    public ReactiveAgent(Memory memory, String name) throws Exception {
        super(memory);
        this.name = name;
        this.initializeActorSystem();
    }

    public void terminate() {
        this.terminate((Duration)this.defaultTerminationTimeout);
    }

    public void terminate(Duration timeout) {
        system.terminate();
        system.awaitTermination(timeout);
    }

    public static ReactiveAgent create(Memory memory) throws Exception {
        return new ReactiveAgent(memory);
    }

    public static ReactiveAgent createFrom(Agent agent) throws Exception {
        return (ReactiveAgent)new ReactiveAgent(agent.getMemory()).setTools(agent.getTools()).setNarrators(agent.getNarrators());
    }

    public static ReactiveAgent create(CoreMemory coreMemory, String name) throws Exception {
        return new ReactiveAgent((Memory)coreMemory, name);
    }

    public <RESULT> Either<RESULT, Failure> performsReactively(ReactiveMission<RESULT> reactiveMission) {
        Either<Object, Failure> result;
        Optional<MissionStrategy> strategyToUse = this.decideStrategyToUse(reactiveMission);
        strategyToUse.ifPresent(strategy -> reactiveMission.withStrategy((MissionStrategy)strategy));
        try {
            String strategySet = (String)Await.result((Awaitable)Patterns.ask((ActorRef)this.master, (Object)ReactiveMissionEvent.asEvent(this, reactiveMission), (long)1000L), (Duration)this.timeout);
            if (strategySet != "setStrategyCompleted") {
                throw new StrategyException("not properly set");
            }
            FiniteDuration allowedDuration = (FiniteDuration)reactiveMission.strategy().get().timeoutStrategy().first();
            Timeout timeoutFromStrategy = Timeout.durationToTimeout((FiniteDuration)allowedDuration);
            Object r = Await.result((Awaitable)Patterns.ask((ActorRef)this.slave, (Object)ReactiveMissionEvent.asEvent(this, reactiveMission), (Timeout)timeoutFromStrategy), (Duration)allowedDuration);
            result = Either.left(r);
        }
        catch (Exception e) {
            this.failure = Failure.failure(e);
            result = Either.right(this.failure);
            this.failed = true;
        }
        return result;
    }

    public <RESULT> Either<RESULT, Failure> performsReactively(ReactiveMission<RESULT> reactiveMission, MissionStrategy missionStrategy) {
        return this.performsReactively(reactiveMission.withStrategy(missionStrategy));
    }

    private Optional<MissionStrategy> decideStrategyToUse(ReactiveMission reactiveMission) {
        if (reactiveMission.hasStrategy().booleanValue()) {
            return reactiveMission.strategy();
        }
        if (this.iHaveDefaultStrategy()) {
            return Optional.ofNullable(this.defaultStrategy);
        }
        return Optional.empty();
    }

    private boolean iHaveDefaultStrategy() {
        return this.defaultStrategy != null;
    }

    public ReactiveAgent withDefaultEventStrategy(MissionStrategy missionStrategy) {
        this.defaultStrategy = missionStrategy;
        return this;
    }

    public Boolean hasFailed() {
        return this.failed;
    }

    public Failure getFailure() {
        return this.failure;
    }

    public <TYPE> TYPE getFailureAs(Class<TYPE> type) {
        return this.failure.getContentAs(type);
    }

    public ReactiveAgent resetFailure() {
        this.failure = Failure.empty();
        this.failed = false;
        return this;
    }
}

