/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cherry.reactive;

import akka.japi.Pair;
import io.magentys.Mission;
import io.magentys.cherry.reactive.Eventful;
import io.magentys.cherry.reactive.events.CherryEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public class MissionStrategy
implements Eventful<MissionStrategy> {
    private List<Mission> beforeMissions = new ArrayList<Mission>();
    private List<Mission> afterMissions = new ArrayList<Mission>();
    private Pair<FiniteDuration, List<Mission>> durationToMissions = Pair.create((Object)Duration.create((long)1L, (TimeUnit)TimeUnit.SECONDS), new ArrayList());
    private Map<String, List<Mission>> eventToMissions = new ConcurrentHashMap<String, List<Mission>>();
    private Map<Class<? extends Throwable>, List<Mission>> exceptionToMissions = new ConcurrentHashMap<Class<? extends Throwable>, List<Mission>>();
    private Integer timesToRetry = 0;
    private Boolean shouldNarrateExecutionTime = false;
    private boolean catchAllExceptions = false;
    private List<Mission> catchAllMissions = new ArrayList<Mission>();

    MissionStrategy() {
    }

    public static MissionStrategy aStrategy() {
        return new MissionStrategy();
    }

    public List<Mission> beforeMissions() {
        return this.beforeMissions;
    }

    public Pair<FiniteDuration, List<Mission>> timeoutStrategy() {
        return this.durationToMissions;
    }

    public Map<String, List<Mission>> eventToMissions() {
        return this.eventToMissions;
    }

    public Map<Class<? extends Throwable>, List<Mission>> exceptionToMissions() {
        return this.exceptionToMissions;
    }

    @Override
    public MissionStrategy timeout(FiniteDuration duration, Mission ... missions) {
        this.durationToMissions = Pair.create((Object)duration, Arrays.asList(missions));
        return this;
    }

    @Override
    public MissionStrategy timesToRetry(Integer times, Mission ... missions) {
        this.timesToRetry = times;
        return this;
    }

    @Override
    public MissionStrategy on(CherryEvent event, Mission ... missions) {
        return this;
    }

    @Override
    public MissionStrategy on(Class<? extends Throwable> throwableEvent, Mission ... missions) {
        this.exceptionToMissions.put(throwableEvent, Arrays.asList(missions));
        return this;
    }

    @Override
    public MissionStrategy onAnyException(Mission ... missions) {
        this.catchAllExceptions = true;
        this.catchAllMissions = Arrays.asList(missions);
        return this;
    }

    @Override
    public MissionStrategy onEvents(Set<CherryEvent> cherryEvents, Mission ... missions) {
        return this;
    }

    @Override
    public MissionStrategy onExceptions(Set<Class<? extends Throwable>> events, Mission ... missions) {
        return this;
    }

    @Override
    public MissionStrategy first(Mission ... missions) {
        this.beforeMissions = Arrays.asList(missions);
        return this;
    }

    @Override
    public MissionStrategy onSuccess(Mission ... missions) {
        this.afterMissions = Arrays.asList(missions);
        return this;
    }

    @Override
    public MissionStrategy setNarrateExecutionTime(boolean shouldNarrateExecutionTime) {
        this.shouldNarrateExecutionTime = shouldNarrateExecutionTime;
        return this;
    }

    @Override
    public Boolean shouldNarrateExecutionTime() {
        return this.shouldNarrateExecutionTime;
    }

    @Override
    public int retries() {
        return this.timesToRetry;
    }

    public List<Mission> afterMissions() {
        return this.afterMissions;
    }
}

