/*
 * Decompiled with CFR 0.152.
 */
package io.magentys.cherry.reactive;

import io.magentys.Mission;
import io.magentys.cherry.reactive.MissionStrategy;
import io.magentys.cherry.reactive.ReactiveMission;
import io.magentys.cherry.reactive.events.CherryEvent;
import java.util.Optional;
import java.util.Set;
import scala.concurrent.duration.FiniteDuration;

public abstract class BaseReactiveMission<RESULT>
implements ReactiveMission<RESULT> {
    private MissionStrategy missionStrategy;

    private MissionStrategy myStrategy() {
        if (this.missionStrategy == null) {
            this.missionStrategy = new MissionStrategy();
        }
        return this.missionStrategy;
    }

    @Override
    public ReactiveMission<RESULT> timeout(FiniteDuration duration, Mission ... missions) {
        this.myStrategy().timeout(duration, missions);
        return this;
    }

    @Override
    public ReactiveMission<RESULT> timesToRetry(Integer times, Mission ... missions) {
        this.myStrategy().timesToRetry(times, missions);
        return this;
    }

    @Override
    public ReactiveMission<RESULT> on(CherryEvent event, Mission ... missions) {
        this.myStrategy().on(event, missions);
        return this;
    }

    @Override
    public ReactiveMission<RESULT> on(Class<? extends Throwable> throwableEvent, Mission ... missions) {
        this.myStrategy().on((Class)throwableEvent, missions);
        return this;
    }

    @Override
    public ReactiveMission<RESULT> onAnyException(Mission ... missions) {
        this.myStrategy().onAnyException(missions);
        return this;
    }

    @Override
    public ReactiveMission<RESULT> onEvents(Set<CherryEvent> cherryEvents, Mission ... missions) {
        this.myStrategy().onEvents((Set)cherryEvents, missions);
        return this;
    }

    @Override
    public ReactiveMission<RESULT> onExceptions(Set<Class<? extends Throwable>> events, Mission ... missions) {
        this.myStrategy().onExceptions((Set)events, missions);
        return this;
    }

    @Override
    public ReactiveMission<RESULT> first(Mission ... missions) {
        this.myStrategy().first(missions);
        return this;
    }

    @Override
    public ReactiveMission<RESULT> onSuccess(Mission ... missions) {
        this.myStrategy().onSuccess(missions);
        return this;
    }

    @Override
    public ReactiveMission<RESULT> withStrategy(MissionStrategy missionStrategy) {
        this.missionStrategy = missionStrategy;
        return this;
    }

    @Override
    public Optional<MissionStrategy> strategy() {
        return Optional.ofNullable(this.missionStrategy);
    }

    @Override
    public Boolean hasStrategy() {
        return this.missionStrategy != null;
    }

    @Override
    public ReactiveMission<RESULT> setNarrateExecutionTime(boolean shouldNarrateExecutionTime) {
        this.myStrategy().setNarrateExecutionTime(shouldNarrateExecutionTime);
        return this;
    }

    @Override
    public int retries() {
        return this.myStrategy().retries();
    }

    @Override
    public Boolean shouldNarrateExecutionTime() {
        return this.myStrategy().shouldNarrateExecutionTime();
    }
}

