/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.limiter.provider.key;

import io.lsn.spring.limiter.limited.LimitedInformationProvider;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class KeyBuilder {
    public static String build(Method method, ProceedingJoinPoint point, String managerName) {
        String key = KeyBuilder.buildFromExpression(method, point);
        if (key != null) {
            return KeyBuilder.concatWith(key, managerName);
        }
        if (LimitedInformationProvider.isAsync(method)) {
            return KeyBuilder.concatWith(KeyBuilder.buildForAsync(method), managerName);
        }
        return KeyBuilder.concatWith(KeyBuilder.build(method), managerName);
    }

    public static String build(Method method) {
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return Arrays.asList(hostname, method.getDeclaringClass().getName(), method.getName(), String.valueOf(method.hashCode())).stream().filter(Objects::nonNull).collect(Collectors.joining("-"));
    }

    public static String buildForAsync(Method method) {
        return Arrays.asList(method.getDeclaringClass().getName(), method.getName(), String.valueOf(method.hashCode())).stream().filter(Objects::nonNull).collect(Collectors.joining("-"));
    }

    public static String buildFromExpression(Method method, ProceedingJoinPoint point) {
        String expression = LimitedInformationProvider.keyExpression(method);
        if (expression == null || expression.isEmpty()) {
            return null;
        }
        Object[] args = point.getArgs();
        LocalVariableTableParameterNameDiscoverer discoverer = new LocalVariableTableParameterNameDiscoverer();
        List parameterNames = Arrays.asList(discoverer.getParameterNames(method)).stream().collect(Collectors.toList());
        Map<String, Object> parameters = IntStream.range(0, args.length).boxed().collect(Collectors.toMap(i -> (String)parameterNames.get((int)i), i -> args[i]));
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(expression);
        StandardEvaluationContext context = new StandardEvaluationContext();
        parameters.keySet().stream().forEach(arg_0 -> KeyBuilder.lambda$buildFromExpression$2((EvaluationContext)context, parameters, arg_0));
        return (String)exp.getValue((EvaluationContext)context, String.class);
    }

    private static String concatWith(String key, String managerName) {
        if (managerName == null) {
            return key;
        }
        return key.concat("-").concat(managerName);
    }

    private static /* synthetic */ void lambda$buildFromExpression$2(EvaluationContext context, Map parameters, String key) {
        context.setVariable(key, parameters.get(key));
    }
}

