/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.limiter.provider;

import io.lsn.spring.limiter.provider.LimitProviderInterface;
import io.lsn.spring.limiter.provider.key.KeyBuilder;
import java.lang.reflect.Method;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component
public class CacheLimitProvider
implements LimitProviderInterface {
    public static final String CACHE_LIMIT_NAME_CACHE = "io.lsn.spring.limiter.data";
    private Map<String, CacheManager> cacheManagerMap;

    @Autowired
    public CacheLimitProvider(Map<String, CacheManager> cacheManagerMap) {
        this.cacheManagerMap = cacheManagerMap;
    }

    @Override
    public int current(Method method, ProceedingJoinPoint point, String managerName) {
        String key = KeyBuilder.build(method, point, managerName);
        Integer current = (Integer)this.getCache(managerName).get((Object)key, Integer.class);
        if (current == null) {
            current = 0;
        }
        return current;
    }

    @Override
    public void increase(Method method, ProceedingJoinPoint point, String managerName) {
        int current = this.current(method, point, managerName);
        String key = KeyBuilder.build(method, point, managerName);
        this.getCache(managerName).put((Object)key, (Object)(current + 1));
    }

    @Override
    public void decrease(Method method, ProceedingJoinPoint point, String managerName) {
        int current = this.current(method, point, managerName);
        if (current == 0) {
            return;
        }
        String key = KeyBuilder.build(method, point, managerName);
        this.getCache(managerName).put((Object)key, (Object)(current - 1));
    }

    private Cache getCache(String managerName) {
        return this.cacheManagerMap.get(CACHE_LIMIT_NAME_CACHE).getCache(managerName);
    }
}

