/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.limiter.limiter;

import io.lsn.spring.limiter.LimitExceededException;
import io.lsn.spring.limiter.configuration.EntryLimit;
import io.lsn.spring.limiter.configuration.LimiterProperties;
import io.lsn.spring.limiter.limited.LimitedInformationProvider;
import io.lsn.spring.limiter.provider.LimitProviderInterface;
import io.lsn.spring.limiter.provider.key.KeyBuilder;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Limiter {
    private LimitProviderInterface provider;
    private LimiterProperties configuration;

    @Autowired
    public Limiter(LimitProviderInterface provider, LimiterProperties configuration) {
        this.provider = provider;
        this.configuration = configuration;
    }

    public Object proceed(ProceedingJoinPoint point, Method target) throws Throwable {
        String key = KeyBuilder.build(target, point, null);
        EntryLimit configurationForKey = this.configuration.getEntries().get(key);
        if (configurationForKey == null) {
            return point.proceed();
        }
        Object toReturn = null;
        for (String managerName : configurationForKey.getLimits().keySet()) {
            toReturn = this.proceedSingle(point, target, managerName, toReturn);
        }
        return toReturn;
    }

    private Object proceedSingle(ProceedingJoinPoint point, Method target, String managerName, Object toReturn) throws Throwable {
        int current = this.provider.current(target, point, managerName);
        this.provider.increase(target, point, managerName);
        if (++current >= this.getLimit(point, target, managerName)) {
            this.provider.decrease(target, point, managerName);
            throw new LimitExceededException();
        }
        if (toReturn == null) {
            toReturn = point.proceed();
        }
        if (LimitedInformationProvider.isAsync(target)) {
            this.provider.decrease(target, point, managerName);
        }
        return toReturn;
    }

    private Integer getLimit(ProceedingJoinPoint point, Method target, String managerName) {
        String key = KeyBuilder.build(target, point, null);
        if (this.configuration.getEntries().containsKey(key)) {
            return this.configuration.getEntries().get(key).getLimits().get(managerName);
        }
        return LimitedInformationProvider.limit(target);
    }
}

