/*
 * Decompiled with CFR 0.152.
 */
package io.lsn.spring.limiter.configuration;

import io.lsn.spring.limiter.configuration.LimiterProperties;
import java.time.Duration;
import java.util.HashMap;
import java.util.TimeZone;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LimiterProperties.class})
public class LimiterAutoConfiguration {
    public static String CACHE_MINUTE = "limiterCacheMinute";
    public static String CACHE_HOUR = "limiterCacheHour";

    @Bean(value={"io.lsn.spring.limiter.data"})
    CacheManager limiterCacheManager(RedissonClient redissonClient) {
        JsonJacksonCodec codec = new JsonJacksonCodec();
        codec.getObjectMapper().setTimeZone(TimeZone.getDefault());
        HashMap<String, CacheConfig> config = new HashMap<String, CacheConfig>();
        config.put(CACHE_MINUTE, new CacheConfig(Duration.ofMinutes(1L).toMillis(), Duration.ofMinutes(1L).toMillis()));
        config.put(CACHE_HOUR, new CacheConfig(Duration.ofHours(1L).toMillis(), Duration.ofHours(1L).toMillis()));
        return new RedissonSpringCacheManager(redissonClient, config, (Codec)codec);
    }
}

