package io.lsn.spring.limiter.support;

import io.lsn.spring.limiter.LimitExceededException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

/**
 * @author Patryk Szlagowski <patryksz@lsnova.pl>
 */
@RestControllerAdvice
public class ControllerAdvice {

    @ResponseStatus(value = HttpStatus.LOCKED, reason = "Entity not found")
    @ExceptionHandler(LimitExceededException.class)
    public void handleNotFoundException() {
    }
}
