package io.lsn.spring.limiter.limited;

import java.lang.reflect.Method;

/**
 * @author Patryk Szlagowski <patryksz@lsnova.pl>
 */
public class LimitedInformationProvider {

    /**
     * get limit
     *
     * @param target
     * @return
     */
    public static int limit(Method target) {
        return target.getAnnotation(Limited.class).limit();
    }

    /**
     * is async
     *
     * @param target
     * @return
     */
    public static boolean isAsync(Method target) {
        return target.getAnnotation(Limited.class).async();
    }

    /**
     * get key keyExpression
     *
     * @param target
     * @return
     */
    public static String keyExpression(Method target) {
        Limited annotation = target.getAnnotation(Limited.class);
        if (annotation == null) {
            return "";
        }
        return annotation.key();
    }
}
