package io.lsn.spring.limiter.configuration;

import io.lsn.spring.limiter.provider.CacheLimitProvider;
import org.redisson.api.RedissonClient;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.spring.cache.CacheConfig;
import org.redisson.spring.cache.RedissonSpringCacheManager;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

/**
 * @author Patryk Szlagowski <patryksz@lsnova.pl>
 */
@Configuration
@EnableConfigurationProperties({LimiterProperties.class})
public class LimiterAutoConfiguration {

    public static String CACHE_MINUTE = "limiterCacheMinute";
    public static String CACHE_HOUR = "limiterCacheHour";

    @Bean(CacheLimitProvider.CACHE_LIMIT_NAME_CACHE)
    CacheManager limiterCacheManager(RedissonClient redissonClient) {
        JsonJacksonCodec codec = new JsonJacksonCodec();
        codec.getObjectMapper().setTimeZone(TimeZone.getDefault());
        Map<String, CacheConfig> config = new HashMap<>();
        config.put(CACHE_MINUTE, new CacheConfig(Duration.ofMinutes(1).toMillis(), Duration.ofMinutes(1).toMillis()));
        config.put(CACHE_HOUR, new CacheConfig(Duration.ofHours(1).toMillis(), Duration.ofHours(1).toMillis()));
        return new RedissonSpringCacheManager(redissonClient, config, codec);
    }
}
