package io.lsn.spring.limiter;

import io.lsn.logger.factory.LoggerFactory;
import io.lsn.logger.factory.logger.Logger;
import io.lsn.spring.limiter.limiter.Limiter;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * @author Patryk Szlagowski <patryksz@lsnova.pl>
 */
@Aspect
@Component
public class LimitedAspect {
    private final static Logger logger = LoggerFactory.getLogger(LimitedAspect.class);
    private Limiter limiter;

    @Autowired
    public LimitedAspect(Limiter limiter) {
        this.limiter = limiter;
    }

    @Pointcut("@annotation(io.lsn.spring.limiter.limited.Limited)")
    public void annotation(){}

    @Pointcut("execution(* *(..))")
    public void execute() {}

    @Around("(annotation()) && execute()")
    public Object proceed(ProceedingJoinPoint point) throws Throwable {
        Method target = ((MethodSignature) point.getSignature()).getMethod();
        Object toReturn = null;
        try {
            toReturn = limiter.proceed(point, target);
        } catch (Throwable e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return toReturn;
    }
}
