/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal.taskdefutil;

import io.littlehorse.sdk.common.exception.TaskSchemaMismatchError;
import io.littlehorse.sdk.common.proto.PutTaskDefRequest;
import io.littlehorse.sdk.common.proto.VariableDef;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.wfsdk.internal.taskdefutil.LHTaskSignature;
import java.util.List;
import java.util.Map;

public class TaskDefBuilder {
    public Object executable;
    public LHTaskSignature signature;

    public TaskDefBuilder(Object executable, String taskDefName, Map<String, String> valuesForPlaceHolders) throws TaskSchemaMismatchError {
        this.signature = new LHTaskSignature(taskDefName, executable, valuesForPlaceHolders);
        this.executable = executable;
    }

    public PutTaskDefRequest toPutTaskDefRequest() {
        PutTaskDefRequest.Builder out = PutTaskDefRequest.newBuilder();
        List<String> varNames = this.signature.getVarNames();
        List<VariableType> varTypes = this.signature.getParamTypes();
        for (int i = 0; i < varNames.size(); ++i) {
            out.addInputVars(VariableDef.newBuilder().setName(varNames.get(i)).setType(varTypes.get(i)));
        }
        out.setName(this.signature.taskDefName);
        return out.build();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TaskDefBuilder)) {
            return false;
        }
        TaskDefBuilder other = (TaskDefBuilder)o;
        return this.signature.equals(other.signature) && this.signature.getTaskDefName().equals(other.signature.getTaskDefName());
    }

    public int hashCode() {
        return this.signature.getTaskDefName().hashCode();
    }

    public String getTaskDefName() {
        return this.signature.getTaskDefName();
    }
}

