/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal;

import io.littlehorse.sdk.common.exception.LHMisconfigurationException;
import io.littlehorse.sdk.common.proto.ExponentialBackoffRetryPolicy;
import io.littlehorse.sdk.common.proto.PutTaskDefRequest;
import io.littlehorse.sdk.common.proto.PutWfSpecRequest;
import io.littlehorse.sdk.common.proto.ThreadRetentionPolicy;
import io.littlehorse.sdk.common.proto.WfSpec;
import io.littlehorse.sdk.wfsdk.ThreadFunc;
import io.littlehorse.sdk.wfsdk.Workflow;
import io.littlehorse.sdk.wfsdk.internal.WorkflowThreadImpl;
import io.littlehorse.sdk.wfsdk.internal.taskdefutil.TaskDefBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class WorkflowImpl
extends Workflow {
    private PutWfSpecRequest compiledWorkflow = null;
    private Map<String, TaskDefBuilder> taskDefBuilders = new HashMap<String, TaskDefBuilder>();
    private Set<String> requiredTaskDefNames = new HashSet<String>();
    private Set<String> requiredEedNames = new HashSet<String>();

    public WorkflowImpl(String name, ThreadFunc entrypointThreadFunc) {
        super(name, entrypointThreadFunc);
    }

    public Set<PutTaskDefRequest> compileTaskDefs() {
        this.compileWorkflow();
        HashSet<PutTaskDefRequest> out = new HashSet<PutTaskDefRequest>();
        for (TaskDefBuilder tdb : this.taskDefBuilders.values()) {
            out.add(tdb.toPutTaskDefRequest());
        }
        return out;
    }

    @Override
    public PutWfSpecRequest compileWorkflow() {
        if (this.compiledWorkflow == null) {
            this.compiledWorkflow = this.compileWorkflowHelper();
        }
        return this.compiledWorkflow;
    }

    public void addTaskDefName(String taskDefName) {
        this.requiredTaskDefNames.add(taskDefName);
    }

    public void addExternalEventDefName(String eedName) {
        this.requiredEedNames.add(eedName);
    }

    public void addTaskDefBuilder(TaskDefBuilder tdb) {
        TaskDefBuilder previous = this.taskDefBuilders.get(tdb.getTaskDefName());
        if (previous != null) {
            if (!previous.signature.equals(tdb.signature)) {
                throw new RuntimeException("Tried to register two DIFFERENT tasks named " + tdb.getTaskDefName());
            }
        } else {
            this.taskDefBuilders.put(tdb.getTaskDefName(), tdb);
        }
    }

    @Override
    public Set<String> getRequiredTaskDefNames() {
        if (this.compiledWorkflow == null) {
            this.compiledWorkflow = this.compileWorkflowHelper();
        }
        return this.requiredTaskDefNames;
    }

    @Override
    public Set<String> getRequiredExternalEventDefNames() {
        if (this.compiledWorkflow == null) {
            this.compiledWorkflow = this.compileWorkflowHelper();
        }
        return this.requiredEedNames;
    }

    private PutWfSpecRequest compileWorkflowHelper() {
        String entrypointThreadName = this.addSubThread("entrypoint", this.entrypointThread);
        this.spec.setEntrypointThreadName(entrypointThreadName);
        while (!this.threadFuncs.isEmpty()) {
            Pair nextFunc = (Pair)this.threadFuncs.remove();
            ThreadFunc threadObj = (ThreadFunc)nextFunc.getValue();
            String funcName = (String)nextFunc.getKey();
            WorkflowThreadImpl thr = new WorkflowThreadImpl(this.name, this, threadObj);
            this.spec.putThreadSpecs(funcName, thr.getSpec().build());
        }
        if (this.wfRetentionPolicy != null) {
            this.spec.setRetentionPolicy(this.wfRetentionPolicy);
        }
        if (this.parentWfSpecName != null) {
            this.spec.setParentWfSpec(WfSpec.ParentWfSpecReference.newBuilder().setWfSpecName(this.parentWfSpecName));
        }
        return this.spec.build();
    }

    ThreadRetentionPolicy getDefaultThreadRetentionPolicy() {
        return this.defaultThreadRetentionPolicy;
    }

    public Set<Object> getTaskExecutables() {
        this.compileWorkflow();
        HashSet<Object> out = new HashSet<Object>();
        for (TaskDefBuilder tdb : this.taskDefBuilders.values()) {
            out.add(tdb.executable);
        }
        return out;
    }

    public String addSubThread(String subThreadName, ThreadFunc subThreadFunc) {
        for (Pair pair : this.threadFuncs) {
            if (!((String)pair.getKey()).equals(subThreadName)) continue;
            throw new LHMisconfigurationException(String.format("Thread %s already exists", subThreadName));
        }
        this.threadFuncs.add(Pair.of((Object)subThreadName, (Object)subThreadFunc));
        return subThreadName;
    }

    protected Optional<ExponentialBackoffRetryPolicy> getDefaultExponentialBackoffRetryPolicy() {
        return Optional.ofNullable(this.defaultExponentialBackoff);
    }

    protected int getDefaultSimpleRetries() {
        return this.defaultSimpleRetries;
    }
}

