/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal;

import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.exception.LHMisconfigurationException;
import io.littlehorse.sdk.common.exception.LHSerdeError;
import io.littlehorse.sdk.common.proto.JsonIndex;
import io.littlehorse.sdk.common.proto.ThreadVarDef;
import io.littlehorse.sdk.common.proto.VariableDef;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.common.proto.VariableValue;
import io.littlehorse.sdk.common.proto.WfRunVariableAccessLevel;
import io.littlehorse.sdk.wfsdk.WfRunVariable;
import java.util.ArrayList;
import java.util.List;

class WfRunVariableImpl
implements WfRunVariable {
    public String name;
    public VariableType type;
    private VariableValue defaultValue;
    private boolean required;
    private boolean searchable;
    private Object typeOrDefaultVal;
    private List<JsonIndex> jsonIndexes = new ArrayList<JsonIndex>();
    private WfRunVariableAccessLevel accessLevel;
    public String jsonPath;

    public WfRunVariableImpl(String name, Object typeOrDefaultVal) {
        this.name = name;
        this.typeOrDefaultVal = typeOrDefaultVal;
        this.accessLevel = WfRunVariableAccessLevel.PUBLIC_VAR;
        this.initializeType();
    }

    private void initializeType() {
        if (this.typeOrDefaultVal instanceof VariableType) {
            this.type = (VariableType)((Object)this.typeOrDefaultVal);
        } else {
            try {
                this.defaultValue = LHLibUtil.objToVarVal(this.typeOrDefaultVal);
                this.type = LHLibUtil.fromValueCase(this.defaultValue.getValueCase());
            }
            catch (LHSerdeError e) {
                throw new IllegalArgumentException("Was unable to convert provided default value to LH Variable Type", e);
            }
        }
    }

    @Override
    public WfRunVariableImpl withAccessLevel(WfRunVariableAccessLevel accessLevel) {
        this.accessLevel = accessLevel;
        return this;
    }

    @Override
    public WfRunVariableImpl jsonPath(String path) {
        if (this.jsonPath != null) {
            throw new LHMisconfigurationException("Cannot use jsonpath() twice on same var!");
        }
        if (!this.type.equals((Object)VariableType.JSON_OBJ) && !this.type.equals((Object)VariableType.JSON_ARR)) {
            throw new LHMisconfigurationException(String.format("JsonPath not allowed in a %s variable", this.type.name()));
        }
        WfRunVariableImpl out = new WfRunVariableImpl(this.name, this.typeOrDefaultVal);
        out.jsonPath = path;
        return out;
    }

    @Override
    public WfRunVariable searchable() {
        this.searchable = true;
        return this;
    }

    @Override
    public WfRunVariable required() {
        this.required = true;
        return this;
    }

    @Override
    public WfRunVariable searchableOn(String fieldPath, VariableType fieldType) {
        if (!fieldPath.startsWith("$.")) {
            throw new LHMisconfigurationException(String.format("Invalid JsonPath: %s", fieldPath));
        }
        if (!this.type.equals((Object)VariableType.JSON_OBJ) && !this.type.equals((Object)VariableType.JSON_ARR)) {
            throw new LHMisconfigurationException(String.format("Non-Json %s variable contains jsonIndex", this.name));
        }
        this.jsonIndexes.add(JsonIndex.newBuilder().setFieldPath(fieldPath).setFieldType(fieldType).build());
        return this;
    }

    public ThreadVarDef getSpec() {
        VariableDef.Builder varDef = VariableDef.newBuilder().setType(this.getType()).setName(this.getName());
        if (this.defaultValue != null) {
            varDef.setDefaultValue(this.defaultValue);
        }
        return ThreadVarDef.newBuilder().setVarDef(varDef).setRequired(this.required).setSearchable(this.searchable).addAllJsonIndexes(this.jsonIndexes).setAccessLevel(this.accessLevel).build();
    }

    public String getName() {
        return this.name;
    }

    public VariableType getType() {
        return this.type;
    }

    public VariableValue getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public Object getTypeOrDefaultVal() {
        return this.typeOrDefaultVal;
    }

    public List<JsonIndex> getJsonIndexes() {
        return this.jsonIndexes;
    }

    public WfRunVariableAccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }
}

