/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal;

import io.littlehorse.sdk.common.proto.FailureHandlerDef;
import io.littlehorse.sdk.common.proto.LHErrorType;
import io.littlehorse.sdk.common.proto.ThreadSpec;
import io.littlehorse.sdk.wfsdk.ThreadFunc;
import io.littlehorse.sdk.wfsdk.WaitForThreadsNodeOutput;
import io.littlehorse.sdk.wfsdk.internal.NodeOutputImpl;
import io.littlehorse.sdk.wfsdk.internal.WorkflowThreadImpl;
import java.io.Serializable;

class WaitForThreadsNodeOutputImpl
extends NodeOutputImpl
implements WaitForThreadsNodeOutput {
    private final ThreadSpec.Builder threadSpec;

    public WaitForThreadsNodeOutputImpl(String nodeName, WorkflowThreadImpl parent, ThreadSpec.Builder threadSpec) {
        super(nodeName, parent);
        this.threadSpec = threadSpec;
    }

    @Override
    public WaitForThreadsNodeOutput handleExceptionOnChild(String exceptionName, ThreadFunc handler) {
        Object threadName = "exn-handler-" + this.nodeName + "-" + (Serializable)(exceptionName != null ? exceptionName : FailureHandlerDef.LHFailureType.FAILURE_TYPE_EXCEPTION);
        threadName = this.parent.getParent().addSubThread((String)threadName, handler);
        FailureHandlerDef.Builder handlerDef = FailureHandlerDef.newBuilder().setHandlerSpecName((String)threadName);
        if (exceptionName != null) {
            handlerDef.setSpecificFailure(exceptionName);
        } else {
            handlerDef.setAnyFailureOfType(FailureHandlerDef.LHFailureType.FAILURE_TYPE_EXCEPTION);
        }
        this.parent.addFailureHandlerOnWaitForThreadsNode(this, handlerDef.build());
        return this;
    }

    @Override
    public WaitForThreadsNodeOutput handleErrorOnChild(LHErrorType errorType, ThreadFunc handler) {
        Object threadName = "error-handler-" + this.nodeName + "-" + (Serializable)(errorType != null ? errorType.name() : FailureHandlerDef.LHFailureType.FAILURE_TYPE_ERROR);
        threadName = this.parent.getParent().addSubThread((String)threadName, handler);
        FailureHandlerDef.Builder handlerDef = FailureHandlerDef.newBuilder().setHandlerSpecName((String)threadName);
        if (errorType != null) {
            handlerDef.setSpecificFailure(errorType.name());
        } else {
            handlerDef.setAnyFailureOfType(FailureHandlerDef.LHFailureType.FAILURE_TYPE_ERROR);
        }
        this.parent.addFailureHandlerOnWaitForThreadsNode(this, handlerDef.build());
        return this;
    }

    @Override
    public WaitForThreadsNodeOutput handleAnyFailureOnChild(ThreadFunc handler) {
        Object threadName = "failure-handler-" + this.nodeName + "-ANY_FAILURE";
        threadName = this.parent.getParent().addSubThread((String)threadName, handler);
        FailureHandlerDef.Builder handlerDef = FailureHandlerDef.newBuilder().setHandlerSpecName((String)threadName);
        this.parent.addFailureHandlerOnWaitForThreadsNode(this, handlerDef.build());
        return this;
    }
}

