/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.common.auth;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import lombok.NonNull;

public class TokenStatus {
    private String token;
    private Instant expiration;
    private String clientId;
    private String userName;
    private boolean isMachineClient;

    public TokenStatus(@NonNull String token, Instant expiration, String clientId, String userName, boolean isMachineClient) {
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        this.token = token;
        if (expiration == null) {
            expiration = Instant.MIN;
        }
        this.expiration = expiration.truncatedTo(ChronoUnit.SECONDS);
        this.clientId = clientId;
        this.userName = userName;
        this.isMachineClient = isMachineClient;
    }

    public boolean isValid() {
        if (this.clientId == null) {
            return false;
        }
        return this.expiration.isAfter(Instant.now().truncatedTo(ChronoUnit.SECONDS));
    }

    public static TokenStatusBuilder builder() {
        return new TokenStatusBuilder();
    }

    public String getToken() {
        return this.token;
    }

    public Instant getExpiration() {
        return this.expiration;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean isMachineClient() {
        return this.isMachineClient;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenStatus)) {
            return false;
        }
        TokenStatus other = (TokenStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMachineClient() != other.isMachineClient()) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        Instant this$expiration = this.getExpiration();
        Instant other$expiration = other.getExpiration();
        if (this$expiration == null ? other$expiration != null : !((Object)this$expiration).equals(other$expiration)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMachineClient() ? 79 : 97);
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        Instant $expiration = this.getExpiration();
        result = result * 59 + ($expiration == null ? 43 : ((Object)$expiration).hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    public static class TokenStatusBuilder {
        private String token;
        private Instant expiration;
        private String clientId;
        private String userName;
        private boolean isMachineClient;

        TokenStatusBuilder() {
        }

        public TokenStatusBuilder token(String token) {
            this.token = token;
            return this;
        }

        public TokenStatusBuilder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public TokenStatusBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public TokenStatusBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public TokenStatusBuilder isMachineClient(boolean isMachineClient) {
            this.isMachineClient = isMachineClient;
            return this;
        }

        public TokenStatus build() {
            return new TokenStatus(this.token, this.expiration, this.clientId, this.userName, this.isMachineClient);
        }

        public String toString() {
            return "TokenStatus.TokenStatusBuilder(token=" + this.token + ", expiration=" + this.expiration + ", clientId=" + this.clientId + ", userName=" + this.userName + ", isMachineClient=" + this.isMachineClient + ")";
        }
    }
}

