/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.common.auth;

import com.nimbusds.oauth2.sdk.AccessTokenResponse;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.http.HTTPResponse;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import io.littlehorse.sdk.common.auth.AuthorizationServerException;
import io.littlehorse.sdk.common.auth.OAuthConfig;
import io.littlehorse.sdk.common.auth.TokenStatus;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthClient {
    private static final Logger log = LoggerFactory.getLogger(OAuthClient.class);
    private final OAuthConfig config;
    private final ClientAuthentication credentials;

    public OAuthClient(OAuthConfig config) {
        this.config = config;
        this.credentials = new ClientSecretBasic(new ClientID(config.getClientId()), new Secret(config.getClientSecret()));
    }

    public TokenStatus getAccessToken() {
        try {
            TokenRequest request = new TokenRequest(this.config.getTokenEndpointURI(), this.credentials, (AuthorizationGrant)new ClientCredentialsGrant());
            TokenResponse response = TokenResponse.parse((HTTPResponse)request.toHTTPRequest().send());
            if (!response.indicatesSuccess()) {
                throw new AuthorizationServerException("Error getting the token status: " + response.toErrorResponse().getErrorObject());
            }
            AccessTokenResponse successResponse = response.toSuccessResponse();
            AccessToken accessToken = successResponse.getTokens().getAccessToken();
            Instant expiration = Instant.now().truncatedTo(ChronoUnit.SECONDS).plusSeconds(accessToken.getLifetime());
            return TokenStatus.builder().clientId(this.config.getClientId()).token(accessToken.getValue()).expiration(expiration).build();
        }
        catch (ParseException | IOException e) {
            log.error(e.getMessage(), e);
            throw new AuthorizationServerException(e);
        }
    }
}

