/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.littlehorse.sdk.common.proto.VariableValue;
import java.util.Collection;

public final class LHVariableMapper {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private LHVariableMapper() {
    }

    public static int asInt(VariableValue var) {
        LHVariableMapper.enforceType(var.getValueCase(), Integer.class);
        return (int)var.getInt();
    }

    public static long asLong(VariableValue var) {
        LHVariableMapper.enforceType(var.getValueCase(), Long.class);
        return var.getInt();
    }

    public static double asDouble(VariableValue var) {
        LHVariableMapper.enforceType(var.getValueCase(), Double.class);
        return var.getDouble();
    }

    public static boolean asBoolean(VariableValue var) {
        LHVariableMapper.enforceType(var.getValueCase(), Boolean.class);
        return var.getBool();
    }

    public static byte[] asBytes(VariableValue var) {
        LHVariableMapper.enforceType(var.getValueCase(), Byte.class);
        return var.getBytes().toByteArray();
    }

    public static String asString(VariableValue var) {
        LHVariableMapper.enforceType(var.getValueCase(), String.class);
        return var.getStr();
    }

    public static <T> T as(VariableValue var, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(var.getJsonObj(), clazz);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Collection<T> asList(VariableValue var, Class<T> clazz) {
        try {
            LHVariableMapper.enforceType(var.getValueCase(), Collection.class);
            return (Collection)MAPPER.readValue(var.getJsonArr(), (JavaType)TypeFactory.defaultInstance().constructCollectionType(Collection.class, clazz));
        }
        catch (JsonProcessingException exn) {
            throw new RuntimeException(exn);
        }
    }

    private static void enforceType(VariableValue.ValueCase valueCase, Class<?> targetType) {
        boolean isCompatible = false;
        switch (valueCase) {
            case INT: {
                isCompatible = targetType.equals(Integer.class) || targetType.equals(Long.class);
                break;
            }
            case STR: {
                isCompatible = targetType.equals(String.class);
                break;
            }
            case BOOL: {
                isCompatible = targetType.equals(Boolean.class);
                break;
            }
            case BYTES: {
                isCompatible = targetType.equals(Byte.class);
                break;
            }
            case DOUBLE: {
                isCompatible = targetType.equals(Double.class);
                break;
            }
            case JSON_ARR: {
                isCompatible = targetType.equals(Collection.class);
                break;
            }
        }
        if (!isCompatible) {
            throw new IllegalArgumentException(String.format("Not possible to convert variable type %s to %s", valueCase.name(), targetType.getSimpleName()));
        }
    }
}

