/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker.internal;

import io.grpc.stub.StreamObserver;
import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.proto.LHHostInfo;
import io.littlehorse.sdk.common.proto.LHPublicApiGrpc;
import io.littlehorse.sdk.common.proto.PollTaskRequest;
import io.littlehorse.sdk.common.proto.PollTaskResponse;
import io.littlehorse.sdk.common.proto.ScheduledTask;
import io.littlehorse.sdk.worker.internal.LHServerConnectionManager;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHServerConnection
implements Closeable,
StreamObserver<PollTaskResponse> {
    private static final Logger log = LoggerFactory.getLogger(LHServerConnection.class);
    private LHServerConnectionManager manager;
    private LHHostInfo host;
    private boolean stillRunning = true;
    private StreamObserver<PollTaskRequest> pollClient;
    private LHPublicApiGrpc.LHPublicApiStub stub;

    public LHServerConnection(LHServerConnectionManager manager, LHHostInfo host) throws IOException {
        this.manager = manager;
        this.host = host;
        this.stub = manager.config.getAsyncStub(host.getHost(), host.getPort());
        this.pollClient = this.stub.pollTask(this);
        this.askForMoreWork();
    }

    public void onCompleted() {
        log.error("Unexpected call to onCompleted() in the Server Connection.");
        this.stillRunning = false;
        this.manager.onConnectionClosed(this);
    }

    public void onError(Throwable t) {
        log.error("Unexpected error from server", t);
        this.stillRunning = false;
        this.manager.onConnectionClosed(this);
    }

    public void onNext(PollTaskResponse taskToDo) {
        if (taskToDo.hasResult()) {
            ScheduledTask scheduledTask = taskToDo.getResult();
            String wfRunId = LHLibUtil.getWfRunId(scheduledTask.getSource());
            log.info("Received task schedule request for wfRun {}", (Object)wfRunId);
            this.manager.submitTaskForExecution(scheduledTask, this.stub);
            log.info("Scheduled task on threadpool for wfRun {}", (Object)wfRunId);
        } else {
            log.error("Didn't successfully claim task, likely due to server restart.");
        }
        if (this.stillRunning) {
            this.askForMoreWork();
        } else {
            this.pollClient.onCompleted();
        }
    }

    public LHHostInfo getHostInfo() {
        return this.host;
    }

    public boolean isSameAs(LHHostInfo other) {
        return this.host.getHost().equals(other.getHost()) && this.host.getPort() == other.getPort();
    }

    private void askForMoreWork() {
        log.debug("Asking for more work on {}:{}", (Object)this.host.getHost(), (Object)this.host.getPort());
        this.pollClient.onNext((Object)PollTaskRequest.newBuilder().setClientId(this.manager.config.getClientId()).setTaskDefName(this.manager.taskDef.getName()).setTaskWorkerVersion(this.manager.config.getTaskWorkerVersion()).build());
    }

    @Override
    public void close() {
        this.stillRunning = false;
        this.pollClient.onCompleted();
    }
}

