/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker;

import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.proto.NodeRunId;
import io.littlehorse.sdk.common.proto.ScheduledTask;
import io.littlehorse.sdk.common.proto.TaskRunId;
import io.littlehorse.sdk.common.proto.TaskRunSource;
import io.littlehorse.sdk.common.proto.UserTaskTriggerReference;
import java.util.Date;

public class WorkerContext {
    private ScheduledTask scheduledTask;
    private Date scheduleTime;
    private String stderr;

    public WorkerContext(ScheduledTask scheduledTask, Date scheduleTime) {
        this.scheduledTask = scheduledTask;
        this.scheduleTime = scheduleTime;
    }

    public String getWfRunId() {
        return LHLibUtil.getWfRunId(this.scheduledTask.getSource());
    }

    public NodeRunId getNodeRunId() {
        TaskRunSource source = this.scheduledTask.getSource();
        switch (source.getTaskRunSourceCase()) {
            case TASK_NODE: {
                return source.getTaskNode().getNodeRunId();
            }
            case USER_TASK_TRIGGER: {
                return source.getUserTaskTrigger().getNodeRunId();
            }
        }
        return null;
    }

    public int getAttemptNumber() {
        return this.scheduledTask.getAttemptNumber();
    }

    public Date getScheduledTime() {
        return this.scheduleTime;
    }

    public void log(Object thing) {
        this.stderr = thing != null ? this.stderr + thing.toString() : this.stderr + "null";
    }

    public String getLogOutput() {
        return this.stderr;
    }

    public TaskRunId getTaskRunId() {
        return this.scheduledTask.getTaskRunId();
    }

    private UserTaskTriggerReference getUserTaskTrigger() {
        return this.scheduledTask.getSource().hasUserTaskTrigger() ? this.scheduledTask.getSource().getUserTaskTrigger() : null;
    }

    public String getUserId() {
        UserTaskTriggerReference uttr = this.getUserTaskTrigger();
        if (uttr == null) {
            return null;
        }
        return uttr.hasUserId() ? uttr.getUserId() : null;
    }

    public String getUserGroup() {
        UserTaskTriggerReference uttr = this.getUserTaskTrigger();
        if (uttr == null) {
            return null;
        }
        return uttr.hasUserGroup() ? uttr.getUserGroup() : null;
    }

    public String getIdempotencyKey() {
        return LHLibUtil.taskRunIdToString(this.getTaskRunId());
    }
}

