/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.config.LHConfig;
import io.littlehorse.sdk.common.exception.LHMisconfigurationException;
import io.littlehorse.sdk.common.exception.TaskSchemaMismatchError;
import io.littlehorse.sdk.common.proto.LHPublicApiGrpc;
import io.littlehorse.sdk.common.proto.TaskDef;
import io.littlehorse.sdk.common.proto.TaskDefId;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.wfsdk.internal.taskdefutil.LHTaskSignature;
import io.littlehorse.sdk.wfsdk.internal.taskdefutil.TaskDefBuilder;
import io.littlehorse.sdk.worker.WorkerContext;
import io.littlehorse.sdk.worker.internal.LHServerConnectionManager;
import io.littlehorse.sdk.worker.internal.util.VariableMapping;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHTaskWorker
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(LHTaskWorker.class);
    public static HashMap<Class<?>, VariableType> javaTypeToLHType = new HashMap<Class<?>, VariableType>(){
        {
            this.put(Integer.class, VariableType.INT);
            this.put(Long.class, VariableType.INT);
            this.put(Boolean.class, VariableType.BOOL);
            this.put(Double.class, VariableType.DOUBLE);
            this.put(byte[].class, VariableType.BYTES);
            this.put(String.class, VariableType.STR);
        }
    };
    private Object executable;
    private LHConfig config;
    private TaskDef taskDef;
    private Method taskMethod;
    private List<VariableMapping> mappings;
    private LHServerConnectionManager manager;
    private String taskDefName;
    private LHPublicApiGrpc.LHPublicApiBlockingStub grpcClient;

    public LHTaskWorker(Object executable, String taskDefName, LHConfig config) throws IOException {
        this.config = config;
        this.executable = executable;
        this.mappings = new ArrayList<VariableMapping>();
        this.taskDefName = taskDefName;
        this.grpcClient = config.getBlockingStub();
    }

    public String getTaskDefName() {
        return this.taskDefName;
    }

    private void createManager() throws IOException {
        this.validateTaskDefAndExecutable();
        this.manager = new LHServerConnectionManager(this.taskMethod, this.taskDef, this.config, this.mappings, this.executable);
    }

    public boolean doesTaskDefExist() {
        try {
            this.grpcClient.getTaskDef(TaskDefId.newBuilder().setName(this.taskDefName).build());
            return true;
        }
        catch (StatusRuntimeException exn) {
            if (exn.getStatus().getCode() == Status.Code.NOT_FOUND) {
                return false;
            }
            throw exn;
        }
    }

    public void registerTaskDef() {
        this.registerTaskDef(false);
    }

    public void registerTaskDef(boolean swallowAlreadyExists) {
        TaskDefBuilder tdb = new TaskDefBuilder(this.executable, this.taskDefName);
        log.info("Creating TaskDef: {}", (Object)this.taskDefName);
        try {
            TaskDef result = this.grpcClient.putTaskDef(tdb.toPutTaskDefRequest());
            log.info("Created TaskDef:\n{}", (Object)LHLibUtil.protoToJson(result));
        }
        catch (StatusRuntimeException exn) {
            if (swallowAlreadyExists && exn.getStatus().getCode() == Status.Code.ALREADY_EXISTS) {
                log.info("TaskDef {} already exists!", (Object)this.taskDefName);
            }
            throw exn;
        }
    }

    private void validateTaskDefAndExecutable() throws TaskSchemaMismatchError {
        if (this.taskDef == null) {
            this.taskDef = this.grpcClient.getTaskDef(TaskDefId.newBuilder().setName(this.taskDefName).build());
        }
        LHTaskSignature signature = new LHTaskSignature(this.taskDef.getName(), this.executable);
        this.taskMethod = signature.getTaskMethod();
        int numTaskMethodParams = this.taskMethod.getParameterCount();
        int numTaskDefParams = this.taskDef.getInputVarsCount();
        boolean wrongNumParams = false;
        if (signature.getHasWorkerContextAtEnd()) {
            if (numTaskMethodParams - 1 != numTaskDefParams) {
                wrongNumParams = true;
            }
        } else if (numTaskDefParams != numTaskMethodParams) {
            wrongNumParams = true;
        }
        if (wrongNumParams) {
            throw new TaskSchemaMismatchError("Number of task method params doesn't match number of taskdef params!");
        }
        for (int i = 0; i < numTaskDefParams; ++i) {
            Parameter param = this.taskMethod.getParameters()[i];
            String javaParamName = param.getName();
            Class<?> paramClass = param.getType();
            if (paramClass.equals(WorkerContext.class)) {
                throw new TaskSchemaMismatchError("Can only have WorkerContext after all required taskDef params.");
            }
            VariableMapping mapping = new VariableMapping(this.taskDef, i, paramClass, javaParamName);
            this.mappings.add(mapping);
        }
        if (signature.getHasWorkerContextAtEnd()) {
            this.mappings.add(new VariableMapping(this.taskDef, numTaskMethodParams - 1, WorkerContext.class, null));
        }
    }

    public void start() throws IOException {
        if (!this.doesTaskDefExist()) {
            throw new LHMisconfigurationException("Couldn't find TaskDef: " + this.taskDefName);
        }
        this.createManager();
        this.manager.start();
    }

    @Override
    public void close() {
        if (this.manager != null) {
            this.manager.close();
        }
    }
}

