/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal.taskdefutil;

import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.exception.TaskSchemaMismatchError;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.worker.LHTaskMethod;
import io.littlehorse.sdk.worker.WorkerContext;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHTaskSignature {
    private static final Logger log = LoggerFactory.getLogger(LHTaskSignature.class);
    List<VariableType> paramTypes = new ArrayList<VariableType>();
    List<String> varNames = new ArrayList<String>();
    Method taskMethod;
    boolean hasWorkerContextAtEnd = false;
    String taskDefName;
    Object executable;

    public LHTaskSignature(String taskDefName, Object executable) throws TaskSchemaMismatchError {
        this.taskDefName = taskDefName;
        this.executable = executable;
        for (Method method : executable.getClass().getMethods()) {
            String taskDefForThisMethod;
            if (!method.isAnnotationPresent(LHTaskMethod.class) || !(taskDefForThisMethod = method.getAnnotation(LHTaskMethod.class).value()).equals(taskDefName)) continue;
            if (this.taskMethod != null) {
                throw new TaskSchemaMismatchError("Found two annotated task methods!");
            }
            this.taskMethod = method;
        }
        if (this.taskMethod == null) {
            throw new TaskSchemaMismatchError("Couldn't find annotated @LHTaskMethod for taskDef " + taskDefName + " on " + executable.getClass());
        }
        for (int i = 0; i < this.taskMethod.getParameterCount(); ++i) {
            Parameter param = this.taskMethod.getParameters()[i];
            if (param.getType().equals(WorkerContext.class)) {
                if (i + 1 != this.taskMethod.getParameterCount()) {
                    throw new TaskSchemaMismatchError("Can only have WorkerContext as the last parameter.");
                }
                this.hasWorkerContextAtEnd = true;
                continue;
            }
            VariableType paramLHType = LHLibUtil.javaClassToLHVarType(param.getType());
            if (!param.isNamePresent()) {
                log.warn("Was unable to inspect parameter names usingreflection; please compile with `javac -Parameters` to enable that.Will use param position as its name, which makes resulting TaskDefharder to understand.");
            }
            this.paramTypes.add(paramLHType);
            this.varNames.add(param.getName());
        }
    }

    public boolean getHasWorkerContextAtEnd() {
        return this.hasWorkerContextAtEnd;
    }

    public List<VariableType> getParamTypes() {
        return this.paramTypes;
    }

    public String getTaskDefName() {
        return this.taskDefName;
    }

    public Object getExecutable() {
        return this.executable;
    }

    public Method getTaskMethod() {
        return this.taskMethod;
    }

    public List<String> getVarNames() {
        return this.varNames;
    }

    public boolean equals(Object other) {
        if (!(other instanceof LHTaskSignature)) {
            return false;
        }
        LHTaskSignature o = (LHTaskSignature)other;
        List<VariableType> otherTypes = o.getParamTypes();
        if (otherTypes.size() != this.paramTypes.size()) {
            return false;
        }
        for (int i = 0; i < otherTypes.size(); ++i) {
            if (otherTypes.get(i).equals((Object)this.paramTypes.get(i))) continue;
            return false;
        }
        return true;
    }
}

