/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal;

import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.exception.LHMisconfigurationException;
import io.littlehorse.sdk.common.exception.LHSerdeError;
import io.littlehorse.sdk.common.proto.IndexType;
import io.littlehorse.sdk.common.proto.JsonIndex;
import io.littlehorse.sdk.common.proto.VariableDef;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.common.proto.VariableValue;
import io.littlehorse.sdk.wfsdk.WfRunVariable;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

class WfRunVariableImpl
implements WfRunVariable {
    public String name;
    public VariableType type;
    public String jsonPath;
    private VariableValue defaultValue;
    private Object typeOrDefaultVal;
    private IndexType indexType;
    private boolean persistent;
    private List<JsonIndex> jsonIndexes = new ArrayList<JsonIndex>();

    public WfRunVariableImpl(String name, Object typeOrDefaultVal) {
        this.name = name;
        this.typeOrDefaultVal = typeOrDefaultVal;
        this.initializeType();
    }

    private void initializeType() {
        if (this.typeOrDefaultVal instanceof VariableType) {
            this.type = (VariableType)((Object)this.typeOrDefaultVal);
        } else {
            try {
                this.defaultValue = LHLibUtil.objToVarVal(this.typeOrDefaultVal);
                this.type = this.defaultValue.getType();
            }
            catch (LHSerdeError e) {
                throw new IllegalArgumentException("Was unable to convert provided default value to LH Variable Type", e);
            }
        }
    }

    @Override
    public WfRunVariableImpl jsonPath(String path) {
        if (this.jsonPath != null) {
            throw new LHMisconfigurationException("Cannot use jsonpath() twice on same var!");
        }
        if (!this.type.equals((Object)VariableType.JSON_OBJ) && !this.type.equals((Object)VariableType.JSON_ARR)) {
            throw new LHMisconfigurationException(String.format("JsonPath not allowed in a %s variable", this.type.name()));
        }
        WfRunVariableImpl out = new WfRunVariableImpl(this.name, this.typeOrDefaultVal);
        out.jsonPath = path;
        return out;
    }

    @Override
    public WfRunVariable withIndex(@NonNull IndexType indexType) {
        if (indexType == null) {
            throw new NullPointerException("indexType is marked non-null but is null");
        }
        this.indexType = indexType;
        return this;
    }

    @Override
    public WfRunVariable withJsonIndex(@NonNull String jsonPath, @NonNull IndexType indexType) {
        if (jsonPath == null) {
            throw new NullPointerException("jsonPath is marked non-null but is null");
        }
        if (indexType == null) {
            throw new NullPointerException("indexType is marked non-null but is null");
        }
        if (!jsonPath.startsWith("$.")) {
            throw new LHMisconfigurationException(String.format("Invalid JsonPath: %s", jsonPath));
        }
        if (!this.type.equals((Object)VariableType.JSON_OBJ)) {
            throw new LHMisconfigurationException(String.format("Non-Json %s variable contains jsonIndex", this.name));
        }
        this.jsonIndexes.add(JsonIndex.newBuilder().setIndexType(indexType).setPath(jsonPath).build());
        return this;
    }

    public VariableDef getSpec() {
        VariableDef.Builder out = VariableDef.newBuilder().setType(this.getType()).setName(this.getName()).setPersistent(this.persistent);
        if (this.getIndexType() != null) {
            out.setIndexType(this.getIndexType());
        }
        for (JsonIndex jsonIndex : this.getJsonIndexes()) {
            out.addJsonIndexes(jsonIndex);
        }
        if (this.defaultValue != null) {
            out.setDefaultValue(this.defaultValue);
        }
        return out.build();
    }

    @Override
    public WfRunVariable persistent() {
        this.persistent = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public VariableType getType() {
        return this.type;
    }

    public String getJsonPath() {
        return this.jsonPath;
    }

    public VariableValue getDefaultValue() {
        return this.defaultValue;
    }

    public Object getTypeOrDefaultVal() {
        return this.typeOrDefaultVal;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public List<JsonIndex> getJsonIndexes() {
        return this.jsonIndexes;
    }
}

