/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal;

import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.common.proto.WaitForThreadsNode;
import io.littlehorse.sdk.common.proto.WaitForThreadsPolicy;
import io.littlehorse.sdk.wfsdk.SpawnedThread;
import io.littlehorse.sdk.wfsdk.SpawnedThreads;
import io.littlehorse.sdk.wfsdk.internal.BuilderUtil;
import io.littlehorse.sdk.wfsdk.internal.WfRunVariableImpl;
import java.util.Collection;
import java.util.List;

public final class FixedSpawnedThreads
implements SpawnedThreads {
    private final Collection<SpawnedThread> spawnedThreads;

    public FixedSpawnedThreads(SpawnedThread ... spawnedThreads) {
        this.spawnedThreads = List.of(spawnedThreads);
    }

    @Override
    public WaitForThreadsNode buildNode() {
        WaitForThreadsNode.Builder waitNode = WaitForThreadsNode.newBuilder();
        for (SpawnedThread spawnedThread : this.spawnedThreads) {
            WfRunVariableImpl threadNumberVariable = (WfRunVariableImpl)spawnedThread.getThreadNumberVariable();
            if (!threadNumberVariable.getType().equals((Object)VariableType.INT)) {
                throw new IllegalArgumentException("Only int variables are supported");
            }
            WaitForThreadsNode.ThreadToWaitFor threadToWaitFor = WaitForThreadsNode.ThreadToWaitFor.newBuilder().setThreadRunNumber(BuilderUtil.assignVariable(threadNumberVariable)).build();
            waitNode.addThreads(threadToWaitFor);
        }
        waitNode.setPolicy(WaitForThreadsPolicy.STOP_ON_FAILURE);
        return waitNode.build();
    }

    public Collection<SpawnedThread> getSpawnedThreads() {
        return this.spawnedThreads;
    }
}

