/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.proto.GetLatestWfSpecRequest;
import io.littlehorse.sdk.common.proto.LHPublicApiGrpc;
import io.littlehorse.sdk.common.proto.PutWfSpecRequest;
import io.littlehorse.sdk.common.proto.WfSpecId;
import io.littlehorse.sdk.wfsdk.ThreadFunc;
import io.littlehorse.sdk.wfsdk.internal.WorkflowImpl;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Workflow {
    private static final Logger log = LoggerFactory.getLogger(Workflow.class);
    protected ThreadFunc entrypointThread;
    protected String name;
    protected PutWfSpecRequest.Builder spec;
    protected Queue<Pair<String, ThreadFunc>> threadFuncs = new LinkedList<Pair<String, ThreadFunc>>();

    protected Workflow(String name, ThreadFunc entrypointThreadFunc) {
        this.entrypointThread = entrypointThreadFunc;
        this.name = name;
        this.spec = PutWfSpecRequest.newBuilder().setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void withRetentionHours(int retentionHours) {
        if (retentionHours < 1) {
            throw new IllegalArgumentException("You must set a value at least 1 or greater");
        }
        this.spec.setRetentionHours(retentionHours);
    }

    public static Workflow newWorkflow(String name, ThreadFunc entrypointThreadFunc) {
        return new WorkflowImpl(name, entrypointThreadFunc);
    }

    public abstract PutWfSpecRequest compileWorkflow();

    public abstract Set<String> getRequiredTaskDefNames();

    public abstract Set<String> getRequiredExternalEventDefNames();

    public String compileWfToJson() {
        PutWfSpecRequest wfSpec = this.compileWorkflow();
        try {
            return JsonFormat.printer().includingDefaultValueFields().print((MessageOrBuilder)wfSpec);
        }
        catch (InvalidProtocolBufferException exn) {
            throw new RuntimeException(exn);
        }
    }

    public boolean doesWfSpecExist(LHPublicApiGrpc.LHPublicApiBlockingStub client) {
        try {
            client.getLatestWfSpec(GetLatestWfSpecRequest.newBuilder().setName(this.name).build());
            return true;
        }
        catch (StatusRuntimeException exn) {
            if (exn.getStatus().getCode() == Status.Code.NOT_FOUND) {
                return false;
            }
            throw exn;
        }
    }

    public boolean doesWfSpecExist(LHPublicApiGrpc.LHPublicApiBlockingStub client, Integer version) {
        if (version == null) {
            return this.doesWfSpecExist(client);
        }
        try {
            client.getWfSpec(WfSpecId.newBuilder().setName(this.name).setVersion(version).build());
            return true;
        }
        catch (StatusRuntimeException exn) {
            if (exn.getStatus().getCode() == Status.Code.NOT_FOUND) {
                return false;
            }
            throw exn;
        }
    }

    public void registerWfSpec(LHPublicApiGrpc.LHPublicApiBlockingStub client) {
        log.info("Creating wfSpec:\n {}", (Object)LHLibUtil.protoToJson(client.putWfSpec(this.compileWorkflow())));
    }

    public void compileAndSaveToDisk(String directory) {
        PutWfSpecRequest wf = this.compileWorkflow();
        String wfFileName = wf.getName() + "-wfspec.json";
        log.info("Saving WfSpec to {}", (Object)wfFileName);
        Workflow.saveProtoToFile(directory, wfFileName, wf);
    }

    private static void saveProtoToFile(String directory, String fileName, MessageOrBuilder content) {
        Path path = Paths.get(directory, fileName);
        try {
            File file = new File(path.toString());
            file.getParentFile().mkdirs();
            Files.write(path, LHLibUtil.protoToJson(content).getBytes(), new OpenOption[0]);
        }
        catch (IOException exn) {
            throw new RuntimeException(exn);
        }
    }
}

