/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.ByteString;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.JsonFormat;
import com.google.protobuf.util.Timestamps;
import io.littlehorse.sdk.common.exception.LHSerdeError;
import io.littlehorse.sdk.common.proto.TaskRunId;
import io.littlehorse.sdk.common.proto.TaskRunSource;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.common.proto.VariableValue;
import java.lang.reflect.InvocationTargetException;
import java.time.Instant;
import java.util.Date;
import java.util.List;

public class LHLibUtil {
    private static ObjectMapper mapper = new ObjectMapper();

    public static Date fromProtoTs(Timestamp proto) {
        if (proto == null) {
            return null;
        }
        Date out = Date.from(Instant.ofEpochSecond(proto.getSeconds(), proto.getNanos()));
        if (out.getTime() == 0L) {
            out = new Date();
        }
        return out;
    }

    public static Timestamp fromDate(Date date) {
        if (date == null) {
            return null;
        }
        return Timestamps.fromMillis((long)date.getTime());
    }

    public static <T extends GeneratedMessageV3> T loadProto(byte[] data, Class<T> cls) throws LHSerdeError {
        try {
            return (T)((GeneratedMessageV3)cls.cast(cls.getMethod("parseFrom", byte[].class).invoke(null, new Object[]{data})));
        }
        catch (IllegalAccessException | NoSuchMethodException exn) {
            exn.printStackTrace();
            throw new RuntimeException("Passed in an invalid proto class. Not possible");
        }
        catch (InvocationTargetException exn) {
            exn.printStackTrace();
            throw new LHSerdeError(exn.getCause(), "Failed loading protobuf: " + exn.getMessage());
        }
    }

    public static String protoToJson(MessageOrBuilder thing) {
        try {
            return JsonFormat.printer().includingDefaultValueFields().print(thing);
        }
        catch (InvalidProtocolBufferException exn) {
            exn.printStackTrace();
            return null;
        }
    }

    public static byte[] toProto(GeneratedMessageV3.Builder<?> builder) {
        return builder.build().toByteArray();
    }

    public static String serializeToJson(Object o) throws JsonProcessingException {
        return mapper.writeValueAsString(o);
    }

    public static <T> T deserializeFromjson(String json, Class<T> cls) throws JsonProcessingException {
        return (T)mapper.readValue(json, cls);
    }

    public static String getWfRunId(TaskRunSource taskRunSource) {
        switch (taskRunSource.getTaskRunSourceCase()) {
            case TASK_NODE: {
                return taskRunSource.getTaskNode().getNodeRunId().getWfRunId();
            }
            case USER_TASK_TRIGGER: {
                return taskRunSource.getUserTaskTrigger().getNodeRunId().getWfRunId();
            }
        }
        return null;
    }

    public static String taskRunIdToString(TaskRunId taskRunId) {
        return taskRunId.getWfRunId() + "/" + taskRunId.getTaskGuid();
    }

    public static VariableValue objToVarVal(Object o) throws LHSerdeError {
        if (o instanceof VariableValue) {
            return (VariableValue)o;
        }
        VariableValue.Builder out = VariableValue.newBuilder();
        if (o == null) {
            out.setType(VariableType.NULL);
        } else if (Long.class.isAssignableFrom(o.getClass())) {
            out.setType(VariableType.INT);
            out.setInt((Long)o);
        } else if (Integer.class.isAssignableFrom(o.getClass())) {
            out.setType(VariableType.INT);
            out.setInt(((Integer)o).intValue());
        } else if (Double.class.isAssignableFrom(o.getClass())) {
            out.setType(VariableType.DOUBLE);
            out.setDouble((Double)o);
        } else if (Float.class.isAssignableFrom(o.getClass())) {
            out.setType(VariableType.DOUBLE);
            out.setDouble(((Float)o).floatValue());
        } else if (o instanceof String) {
            out.setType(VariableType.STR);
            out.setStr((String)o);
        } else if (o instanceof Boolean) {
            out.setType(VariableType.BOOL);
            out.setBool((Boolean)o);
        } else if (o instanceof byte[]) {
            out.setType(VariableType.BYTES);
            out.setBytes(ByteString.copyFrom((byte[])((byte[])o)));
        } else {
            String jsonStr;
            try {
                jsonStr = LHLibUtil.serializeToJson(o);
            }
            catch (JsonProcessingException exn) {
                exn.printStackTrace();
                throw new LHSerdeError(exn, "Failed deserializing json");
            }
            if (List.class.isAssignableFrom(o.getClass())) {
                out.setType(VariableType.JSON_ARR);
                out.setJsonArr(jsonStr);
            } else {
                out.setType(VariableType.JSON_OBJ);
                out.setJsonObj(jsonStr);
            }
        }
        return out.build();
    }

    public static boolean isINT(Class<?> cls) {
        return Integer.class.isAssignableFrom(cls) || Long.class.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls) || Long.TYPE.isAssignableFrom(cls);
    }

    public static boolean isDOUBLE(Class<?> cls) {
        return Double.class.isAssignableFrom(cls) || Float.class.isAssignableFrom(cls) || Double.TYPE.isAssignableFrom(cls) || Float.TYPE.isAssignableFrom(cls);
    }

    public static boolean isSTR(Class<?> cls) {
        return String.class.isAssignableFrom(cls);
    }

    public static boolean isBOOL(Class<?> cls) {
        return Boolean.class.isAssignableFrom(cls) || Boolean.TYPE.isAssignableFrom(cls);
    }

    public static boolean isBYTES(Class<?> cls) {
        return byte[].class.isAssignableFrom(cls);
    }

    public static boolean isJSON_ARR(Class<?> cls) {
        return List.class.isAssignableFrom(cls);
    }

    public static VariableType javaClassToLHVarType(Class<?> cls) {
        if (LHLibUtil.isINT(cls)) {
            return VariableType.INT;
        }
        if (LHLibUtil.isDOUBLE(cls)) {
            return VariableType.DOUBLE;
        }
        if (LHLibUtil.isSTR(cls)) {
            return VariableType.STR;
        }
        if (LHLibUtil.isBOOL(cls)) {
            return VariableType.BOOL;
        }
        if (LHLibUtil.isBYTES(cls)) {
            return VariableType.BYTES;
        }
        if (LHLibUtil.isJSON_ARR(cls)) {
            return VariableType.JSON_ARR;
        }
        return VariableType.JSON_OBJ;
    }

    public static boolean areVariableValuesEqual(VariableValue a, VariableValue b) {
        if (a.getType() != b.getType()) {
            return false;
        }
        switch (a.getType()) {
            case INT: {
                return a.getInt() == b.getInt();
            }
            case DOUBLE: {
                return a.getDouble() == b.getDouble();
            }
            case STR: {
                return a.getStr().equals(b.getStr());
            }
            case BOOL: {
                return a.getBool() == b.getBool();
            }
            case JSON_ARR: {
                return a.getJsonArr().equals(b.getJsonArr());
            }
            case JSON_OBJ: {
                return a.getJsonObj().equals(b.getJsonObj());
            }
            case BYTES: {
                return a.getBytes().equals((Object)b.getBytes());
            }
            case NULL: {
                return true;
            }
        }
        throw new RuntimeException("Not possible");
    }
}

