/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker.internal.util;

import com.google.protobuf.Empty;
import io.grpc.stub.StreamObserver;
import io.littlehorse.sdk.common.proto.ReportTaskRun;
import io.littlehorse.sdk.worker.internal.LHServerConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportTaskObserver
implements StreamObserver<Empty> {
    private static final Logger log = LoggerFactory.getLogger(ReportTaskObserver.class);
    private LHServerConnectionManager manager;
    private ReportTaskRun reportedTask;
    private int retriesLeft;

    public ReportTaskObserver(LHServerConnectionManager manager, ReportTaskRun reportedTask, int retriesLeft) {
        this.manager = manager;
        this.reportedTask = reportedTask;
        this.retriesLeft = retriesLeft;
    }

    public void onCompleted() {
    }

    public void onError(Throwable t) {
        if (this.retriesLeft > 0) {
            log.error("ReportTask failed, enqueuing retry");
            this.manager.retryReportTask(this.reportedTask, this.retriesLeft - 1);
        } else {
            log.error("ReportTask failed, not enqueueing retry");
            t.printStackTrace();
        }
    }

    public void onNext(Empty reply) {
    }
}

