/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.worker;

import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.proto.NodeRunId;
import io.littlehorse.sdk.common.proto.ScheduledTask;
import io.littlehorse.sdk.common.proto.TaskRunId;
import io.littlehorse.sdk.common.proto.TaskRunSource;
import io.littlehorse.sdk.common.proto.User;
import io.littlehorse.sdk.common.proto.UserGroup;
import java.util.Date;

public class WorkerContext {
    private ScheduledTask scheduledTask;
    private Date scheduleTime;
    private String stderr;

    public WorkerContext(ScheduledTask scheduledTask, Date scheduleTime) {
        this.scheduledTask = scheduledTask;
        this.scheduleTime = scheduleTime;
    }

    public String getWfRunId() {
        return LHLibUtil.getWfRunId(this.scheduledTask.getSource());
    }

    public NodeRunId getNodeRunId() {
        TaskRunSource source = this.scheduledTask.getSource();
        switch (source.getTaskRunSourceCase()) {
            case TASK_NODE: {
                return source.getTaskNode().getNodeRunId();
            }
            case USER_TASK_TRIGGER: {
                return source.getUserTaskTrigger().getNodeRunId();
            }
        }
        return null;
    }

    public int getAttemptNumber() {
        return this.scheduledTask.getAttemptNumber();
    }

    public Date getScheduledTime() {
        return this.scheduleTime;
    }

    public void log(Object thing) {
        this.stderr = thing != null ? this.stderr + thing.toString() : this.stderr + "null";
    }

    public String getLogOutput() {
        return this.stderr;
    }

    public TaskRunId getTaskRunId() {
        return this.scheduledTask.getTaskRunId();
    }

    public User getUser() {
        if (this.scheduledTask.getSource().hasUserTaskTrigger()) {
            return this.scheduledTask.getSource().getUserTaskTrigger().getContext().getUser();
        }
        return null;
    }

    public UserGroup getUserGroup() {
        if (this.scheduledTask.getSource().hasUserTaskTrigger()) {
            return this.scheduledTask.getSource().getUserTaskTrigger().getContext().getUserGroup();
        }
        return null;
    }

    public String getIdempotencyKey() {
        return LHLibUtil.taskRunIdToString(this.getTaskRunId());
    }
}

