/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal.taskdefutil;

import io.littlehorse.sdk.common.exception.TaskSchemaMismatchError;
import io.littlehorse.sdk.common.proto.PutTaskDefRequest;
import io.littlehorse.sdk.common.proto.VariableDef;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.wfsdk.internal.taskdefutil.LHTaskSignature;
import java.util.List;

public class TaskDefBuilder {
    public Object executable;
    public String taskDefName;
    public LHTaskSignature signature;

    public TaskDefBuilder(Object executable, String taskDefName) throws TaskSchemaMismatchError {
        this.signature = new LHTaskSignature(taskDefName, executable);
        this.executable = executable;
        this.taskDefName = taskDefName;
    }

    public PutTaskDefRequest toPutTaskDefRequest() {
        PutTaskDefRequest.Builder out = PutTaskDefRequest.newBuilder();
        List<String> varNames = this.signature.getVarNames();
        List<VariableType> varTypes = this.signature.getParamTypes();
        for (int i = 0; i < varNames.size(); ++i) {
            out.addInputVars(VariableDef.newBuilder().setName(varNames.get(i)).setType(varTypes.get(i)));
        }
        out.setName(this.taskDefName);
        return out.build();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof TaskDefBuilder)) {
            return false;
        }
        TaskDefBuilder other = (TaskDefBuilder)o;
        return this.signature.equals(other.signature) && this.taskDefName.equals(other.taskDefName);
    }

    public int hashCode() {
        return this.taskDefName.hashCode();
    }
}

