/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.wfsdk.internal;

import com.google.protobuf.Message;
import io.littlehorse.sdk.common.LHLibUtil;
import io.littlehorse.sdk.common.exception.LHSerdeError;
import io.littlehorse.sdk.common.exception.TaskSchemaMismatchError;
import io.littlehorse.sdk.common.proto.Comparator;
import io.littlehorse.sdk.common.proto.Edge;
import io.littlehorse.sdk.common.proto.EdgeCondition;
import io.littlehorse.sdk.common.proto.EntrypointNode;
import io.littlehorse.sdk.common.proto.ExitNode;
import io.littlehorse.sdk.common.proto.ExternalEventNode;
import io.littlehorse.sdk.common.proto.FailureDef;
import io.littlehorse.sdk.common.proto.FailureHandlerDef;
import io.littlehorse.sdk.common.proto.InterruptDef;
import io.littlehorse.sdk.common.proto.Node;
import io.littlehorse.sdk.common.proto.NopNode;
import io.littlehorse.sdk.common.proto.SleepNode;
import io.littlehorse.sdk.common.proto.StartMultipleThreadsNode;
import io.littlehorse.sdk.common.proto.StartThreadNode;
import io.littlehorse.sdk.common.proto.TaskNode;
import io.littlehorse.sdk.common.proto.ThreadSpec;
import io.littlehorse.sdk.common.proto.UTActionTrigger;
import io.littlehorse.sdk.common.proto.UserTaskNode;
import io.littlehorse.sdk.common.proto.VariableAssignment;
import io.littlehorse.sdk.common.proto.VariableDef;
import io.littlehorse.sdk.common.proto.VariableMutation;
import io.littlehorse.sdk.common.proto.VariableMutationType;
import io.littlehorse.sdk.common.proto.VariableType;
import io.littlehorse.sdk.common.proto.VariableValue;
import io.littlehorse.sdk.common.proto.WaitForThreadsNode;
import io.littlehorse.sdk.common.proto.WaitForThreadsPolicy;
import io.littlehorse.sdk.wfsdk.IfElseBody;
import io.littlehorse.sdk.wfsdk.LHErrorType;
import io.littlehorse.sdk.wfsdk.NodeOutput;
import io.littlehorse.sdk.wfsdk.SpawnedThread;
import io.littlehorse.sdk.wfsdk.SpawnedThreads;
import io.littlehorse.sdk.wfsdk.ThreadBuilder;
import io.littlehorse.sdk.wfsdk.ThreadFunc;
import io.littlehorse.sdk.wfsdk.UserTaskOutput;
import io.littlehorse.sdk.wfsdk.WaitForThreadsNodeOutput;
import io.littlehorse.sdk.wfsdk.WfRunVariable;
import io.littlehorse.sdk.wfsdk.WorkflowCondition;
import io.littlehorse.sdk.wfsdk.internal.LHFormatStringImpl;
import io.littlehorse.sdk.wfsdk.internal.NodeOutputImpl;
import io.littlehorse.sdk.wfsdk.internal.SpawnedThreadImpl;
import io.littlehorse.sdk.wfsdk.internal.SpawnedThreadsImpl;
import io.littlehorse.sdk.wfsdk.internal.UserTaskOutputImpl;
import io.littlehorse.sdk.wfsdk.internal.WaitForThreadsNodeOutputImpl;
import io.littlehorse.sdk.wfsdk.internal.WfRunVariableImpl;
import io.littlehorse.sdk.wfsdk.internal.WorkflowConditionImpl;
import io.littlehorse.sdk.wfsdk.internal.WorkflowImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ThreadBuilderImpl
implements ThreadBuilder {
    private static final Logger log = LoggerFactory.getLogger(ThreadBuilderImpl.class);
    private WorkflowImpl parent;
    private ThreadSpec.Builder spec;
    private List<WfRunVariableImpl> wfRunVariables = new ArrayList<WfRunVariableImpl>();
    public String lastNodeName;
    public String name;
    private EdgeCondition lastNodeCondition;
    private boolean isActive;

    public ThreadBuilderImpl(String name, WorkflowImpl parent, ThreadFunc func) {
        String entrypointNodeName;
        this.parent = parent;
        this.spec = ThreadSpec.newBuilder();
        this.name = name;
        Node entrypointNode = Node.newBuilder().setEntrypoint(EntrypointNode.newBuilder()).build();
        this.lastNodeName = entrypointNodeName = "0-entrypoint-ENTRYPOINT";
        this.spec.putNodes(entrypointNodeName, entrypointNode);
        this.isActive = true;
        func.threadFunction(this);
        this.addNode("exit", Node.NodeCase.EXIT, (Message)ExitNode.newBuilder().build());
        this.isActive = false;
    }

    public ThreadSpec.Builder getSpec() {
        this.spec.clearVariableDefs();
        for (WfRunVariableImpl wfRunVariable : this.wfRunVariables) {
            this.spec.addVariableDefs(wfRunVariable.getSpec());
        }
        return this.spec;
    }

    @Override
    public UserTaskOutputImpl assignTaskToUser(String userTaskDefName, String userId) {
        return this.assignUserTaskHelper(userTaskDefName, userId, null);
    }

    @Override
    public UserTaskOutput assignTaskToUser(String userTaskDefName, String userId, String userGroup) {
        return this.assignUserTaskHelper(userTaskDefName, userId, userGroup);
    }

    @Override
    public void reassignToGroupOnDeadline(UserTaskOutput userTaskOutput, int deadlineSeconds) {
        this.checkIfIsActive();
        Node.Builder curNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        UserTaskOutputImpl utImpl = (UserTaskOutputImpl)userTaskOutput;
        if (!this.lastNodeName.equals(utImpl.nodeName)) {
            throw new IllegalStateException("Tried to edit a stale User Task node!");
        }
        UserTaskNode.UserAssignment userAssignment = curNode.getUserTaskBuilder().getUser();
        if (userAssignment == null) {
            throw new IllegalStateException("The User Task is not assigned to any user");
        }
        if (!userAssignment.hasUserGroup()) {
            throw new IllegalStateException("The User Task is assigned to a user without a group.");
        }
        VariableAssignment userGroup = userAssignment.getUserGroup();
        this.reassignToGroupOnDeadline(userGroup, curNode, deadlineSeconds);
    }

    @Override
    public void reassignToGroupOnDeadline(UserTaskOutput userTaskOutput, String userGroup, int deadlineSeconds) {
        this.checkIfIsActive();
        Node.Builder curNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        UserTaskOutputImpl utImpl = (UserTaskOutputImpl)userTaskOutput;
        if (!this.lastNodeName.equals(utImpl.nodeName)) {
            throw new IllegalStateException("Tried to edit a stale User Task node!");
        }
        if (userGroup == null || userGroup.isEmpty()) {
            throw new IllegalStateException("User group is required; please provide a valid user group.");
        }
        VariableAssignment userGroupVariableAssignment = this.assignVariable(userGroup);
        this.reassignToGroupOnDeadline(userGroupVariableAssignment, curNode, deadlineSeconds);
    }

    private void reassignToGroupOnDeadline(VariableAssignment userGroup, Node.Builder currentNode, int deadlineSeconds) {
        UTActionTrigger.UTAReassign reassignPb = UTActionTrigger.UTAReassign.newBuilder().setUserGroup(userGroup).build();
        UTActionTrigger actionTrigger = UTActionTrigger.newBuilder().setReassign(reassignPb).setHook(UTActionTrigger.UTHook.ON_TASK_ASSIGNED).setDelaySeconds(this.assignVariable(deadlineSeconds)).build();
        currentNode.getUserTaskBuilder().addActions(actionTrigger);
        this.spec.putNodes(this.lastNodeName, currentNode.build());
    }

    @Override
    public void reassignToUserOnDeadline(UserTaskOutput userTaskOutput, String userId, int deadlineSeconds) {
        this.checkIfIsActive();
        Node.Builder curNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        UserTaskOutputImpl utImpl = (UserTaskOutputImpl)userTaskOutput;
        if (!this.lastNodeName.equals(utImpl.nodeName)) {
            throw new IllegalStateException("Tried to edit a stale User Task node!");
        }
        UTActionTrigger.UTAReassign reassignPb = UTActionTrigger.UTAReassign.newBuilder().setUserId(this.assignVariable(userId)).build();
        UTActionTrigger actionTrigger = UTActionTrigger.newBuilder().setReassign(reassignPb).setHook(UTActionTrigger.UTHook.ON_TASK_ASSIGNED).setDelaySeconds(this.assignVariable(deadlineSeconds)).build();
        curNode.getUserTaskBuilder().addActions(actionTrigger);
        this.spec.putNodes(this.lastNodeName, curNode.build());
    }

    @Override
    public UserTaskOutputImpl assignTaskToUser(String userTaskDefName, WfRunVariable userId) {
        return this.assignUserTaskHelper(userTaskDefName, userId, null);
    }

    @Override
    public UserTaskOutput assignTaskToUser(String userTaskDefName, WfRunVariable userId, String userGroup) {
        return this.assignUserTaskHelper(userTaskDefName, userId, userGroup);
    }

    @Override
    public UserTaskOutput assignTaskToUser(String userTaskDefName, WfRunVariable userId, WfRunVariable userGroup) {
        return this.assignUserTaskHelper(userTaskDefName, userId, userGroup);
    }

    @Override
    public UserTaskOutputImpl assignTaskToUserGroup(String userTaskDefName, String userGroup) {
        return this.assignUserTaskHelper(userTaskDefName, null, userGroup);
    }

    @Override
    public UserTaskOutputImpl assignTaskToUserGroup(String userTaskDefName, WfRunVariable userGroup) {
        return this.assignUserTaskHelper(userTaskDefName, null, userGroup);
    }

    private UserTaskOutputImpl assignUserTaskHelper(String userTaskDefName, Object userId, Object userGroups) {
        VariableAssignment userIdAssn;
        this.checkIfIsActive();
        UserTaskNode.Builder utNode = UserTaskNode.newBuilder().setUserTaskDefName(userTaskDefName);
        if (userId != null) {
            userIdAssn = this.assignVariable(userId);
            VariableAssignment userGroupAssn = userGroups != null ? this.assignVariable(userGroups) : null;
            UserTaskNode.UserAssignment.Builder userAssignmentBuilder = UserTaskNode.UserAssignment.newBuilder();
            userAssignmentBuilder.setUserId(userIdAssn);
            if (userGroupAssn != null) {
                userAssignmentBuilder.setUserGroup(userGroupAssn);
            }
            utNode.setUser(userAssignmentBuilder);
        } else {
            userIdAssn = this.assignVariable(userGroups);
            utNode.setUserGroup(userIdAssn);
        }
        String nodeName = this.addNode(userTaskDefName, Node.NodeCase.USER_TASK, (Message)utNode.build());
        return new UserTaskOutputImpl(nodeName, this);
    }

    @Override
    public void scheduleReminderTask(UserTaskOutput ut, WfRunVariable delaySeconds, String taskDefName, Object ... args) {
        this.scheduleTaskAfterHelper(ut, delaySeconds, taskDefName, args);
    }

    @Override
    public void scheduleReminderTask(UserTaskOutput ut, int delaySeconds, String taskDefName, Object ... args) {
        this.scheduleTaskAfterHelper(ut, delaySeconds, taskDefName, args);
    }

    public void scheduleTaskAfterHelper(UserTaskOutput ut, Object delaySeconds, String taskDefName, Object ... args) {
        this.checkIfIsActive();
        VariableAssignment assn = this.assignVariable(delaySeconds);
        TaskNode taskNode = this.createTaskNode(taskDefName, args);
        UTActionTrigger.UTATask utaTask = UTActionTrigger.UTATask.newBuilder().setTask(taskNode).build();
        UserTaskOutputImpl utImpl = (UserTaskOutputImpl)ut;
        if (!this.lastNodeName.equals(utImpl.nodeName)) {
            throw new RuntimeException("Tried to edit a stale User Task node!");
        }
        Node.Builder curNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        UTActionTrigger.Builder newUtActionBuilder = UTActionTrigger.newBuilder().setTask(utaTask).setHook(UTActionTrigger.UTHook.ON_ARRIVAL).setDelaySeconds(assn);
        curNode.getUserTaskBuilder().addActions(newUtActionBuilder);
        this.spec.putNodes(this.lastNodeName, curNode.build());
    }

    @Override
    public LHFormatStringImpl format(String format, WfRunVariable ... args) {
        return new LHFormatStringImpl(this, format, args);
    }

    @Override
    public NodeOutputImpl execute(String taskName, Object ... args) {
        this.checkIfIsActive();
        TaskNode taskNode = this.createTaskNode(taskName, args);
        String nodeName = this.addNode(taskName, Node.NodeCase.TASK, (Message)taskNode);
        return new NodeOutputImpl(nodeName, this);
    }

    private TaskNode createTaskNode(String taskName, Object ... args) {
        TaskNode.Builder taskNode = TaskNode.newBuilder().setTaskDefName(taskName);
        this.parent.addTaskDefName(taskName);
        for (Object var : args) {
            taskNode.addVariables(this.assignVariable(var));
        }
        return taskNode.build();
    }

    public void checkArgsVsTaskDef(List<VariableDef> taskDefInputVars, String taskDefName, Object ... args) throws TaskSchemaMismatchError {
        if (args.length != taskDefInputVars.size()) {
            throw new TaskSchemaMismatchError("Mismatched number of arguments!");
        }
        for (int i = 0; i < args.length; ++i) {
            VariableType argType;
            Object arg = args[i];
            if (WfRunVariableImpl.class.isAssignableFrom(arg.getClass())) {
                WfRunVariableImpl wfVar = (WfRunVariableImpl)arg;
                if ((wfVar.type == VariableType.JSON_ARR || wfVar.type == VariableType.JSON_OBJ) && wfVar.jsonPath != null) {
                    log.info("There is a jsonpath, so not checking value because Json schema isn't yet implemented");
                    continue;
                }
                argType = wfVar.type;
            } else {
                argType = LHLibUtil.javaClassToLHVarType(arg.getClass());
            }
            if (argType.equals((Object)taskDefInputVars.get(i).getType())) continue;
            throw new TaskSchemaMismatchError("Mismatch var type for param " + i + "on taskdef " + taskDefName + ": " + argType + " not compatible with " + taskDefInputVars.get(i).getType());
        }
    }

    public void addMutationToCurrentNode(VariableMutation mutation) {
        this.checkIfIsActive();
        Node.Builder builder = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        builder.addVariableMutations(mutation);
        this.spec.putNodes(this.lastNodeName, builder.build());
    }

    @Override
    public WfRunVariableImpl addVariable(String name, Object typeOrDefaultVal) {
        this.checkIfIsActive();
        WfRunVariableImpl wfRunVariable = new WfRunVariableImpl(name, typeOrDefaultVal);
        this.wfRunVariables.add(wfRunVariable);
        return wfRunVariable;
    }

    @Override
    public void doIf(WorkflowCondition condition, IfElseBody ifBody) {
        this.checkIfIsActive();
        WorkflowConditionImpl cond = (WorkflowConditionImpl)condition;
        this.addNopNode();
        String treeRootNodeName = this.lastNodeName;
        this.lastNodeCondition = cond.getSpec();
        ifBody.body(this);
        this.addNopNode();
        Node.Builder treeRoot = this.spec.getNodesOrThrow(treeRootNodeName).toBuilder();
        treeRoot.addOutgoingEdges(Edge.newBuilder().setSinkNodeName(this.lastNodeName).setCondition(cond.getReverse()).build());
        this.spec.putNodes(treeRootNodeName, treeRoot.build());
    }

    private void addNopNode() {
        this.checkIfIsActive();
        this.addNode("nop", Node.NodeCase.NOP, (Message)NopNode.newBuilder().build());
    }

    @Override
    public void doIfElse(WorkflowCondition condition, IfElseBody ifBody, IfElseBody elseBody) {
        this.checkIfIsActive();
        WorkflowConditionImpl cond = (WorkflowConditionImpl)condition;
        this.addNopNode();
        String treeRootNodeName = this.lastNodeName;
        this.lastNodeCondition = cond.getSpec();
        ifBody.body(this);
        this.addNopNode();
        String joinerNodeName = this.lastNodeName;
        this.lastNodeName = treeRootNodeName;
        this.lastNodeCondition = cond.getReverse();
        elseBody.body(this);
        if (this.lastNodeCondition != null) {
            throw new RuntimeException("Not possible to have lastNodeCondition after internal call to elseBody.body(this); please contact maintainers. This is a bug.");
        }
        Node.Builder lastNodeFromElseBlock = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        lastNodeFromElseBlock.addOutgoingEdges(Edge.newBuilder().setSinkNodeName(joinerNodeName).build());
        this.spec.putNodes(this.lastNodeName, lastNodeFromElseBlock.build());
        this.lastNodeName = joinerNodeName;
    }

    @Override
    public void doWhile(WorkflowCondition condition, ThreadFunc whileBody) {
        this.checkIfIsActive();
        WorkflowConditionImpl cond = (WorkflowConditionImpl)condition;
        this.addNopNode();
        String treeRootNodeName = this.lastNodeName;
        this.lastNodeCondition = cond.getSpec();
        whileBody.threadFunction(this);
        this.addNopNode();
        String treeLastNodeName = this.lastNodeName;
        Node.Builder treeRoot = this.spec.getNodesOrThrow(treeRootNodeName).toBuilder();
        treeRoot.addOutgoingEdges(Edge.newBuilder().setSinkNodeName(treeLastNodeName).setCondition(cond.getReverse()).build());
        this.spec.putNodes(treeRootNodeName, treeRoot.build());
        Node.Builder treeLast = this.spec.getNodesOrThrow(treeLastNodeName).toBuilder();
        treeLast.addOutgoingEdges(Edge.newBuilder().setSinkNodeName(treeRootNodeName).setCondition(cond.getSpec()).build());
        this.spec.putNodes(treeLastNodeName, treeLast.build());
    }

    @Override
    public SpawnedThreads spawnThreadForEach(WfRunVariable wfRunVariable, String threadName, ThreadFunc threadFunc) {
        return this.spawnThreadForEach(wfRunVariable, threadName, threadFunc, Map.of());
    }

    @Override
    public SpawnedThreads spawnThreadForEach(WfRunVariable wfRunVariable, String threadName, ThreadFunc threadFunc, Map<String, Object> inputVars) {
        this.checkIfIsActive();
        String finalThreadName = this.parent.addSubThread(threadName, threadFunc);
        StartMultipleThreadsNode.Builder startMultiplesThreadNode = StartMultipleThreadsNode.newBuilder().setThreadSpecName(finalThreadName).setIterable(this.assignVariable(wfRunVariable));
        for (Map.Entry<String, Object> inputVar : inputVars.entrySet()) {
            startMultiplesThreadNode.putVariables(inputVar.getKey(), this.assignVariable(inputVar.getValue()));
        }
        String nodeName = this.addNode(threadName, Node.NodeCase.START_MULTIPLE_THREADS, (Message)startMultiplesThreadNode.build());
        WfRunVariableImpl internalStartedThreadVar = this.addVariable(nodeName, (Object)VariableType.JSON_ARR);
        this.mutate(internalStartedThreadVar, VariableMutationType.ASSIGN, new NodeOutputImpl(nodeName, this));
        return new SpawnedThreadsImpl(this, internalStartedThreadVar);
    }

    @Override
    public void sleepSeconds(Object secondsToSleep) {
        this.checkIfIsActive();
        SleepNode.Builder n = SleepNode.newBuilder().setRawSeconds(this.assignVariable(secondsToSleep));
        this.addNode("sleep", Node.NodeCase.SLEEP, (Message)n.build());
    }

    @Override
    public void sleepUntil(WfRunVariable timestamp) {
        this.checkIfIsActive();
        SleepNode.Builder n = SleepNode.newBuilder().setTimestamp(this.assignVariable(timestamp));
        this.addNode("sleep", Node.NodeCase.SLEEP, (Message)n.build());
    }

    @Override
    public SpawnedThreadImpl spawnThread(ThreadFunc threadFunc, String threadName, Map<String, Object> inputVars) {
        this.checkIfIsActive();
        if (inputVars == null) {
            inputVars = new HashMap<String, Object>();
        }
        threadName = this.parent.addSubThread(threadName, threadFunc);
        HashMap<String, VariableAssignment> varAssigns = new HashMap<String, VariableAssignment>();
        for (Map.Entry<String, Object> var : inputVars.entrySet()) {
            varAssigns.put(var.getKey(), this.assignVariable(var.getValue()));
        }
        StartThreadNode startThread = StartThreadNode.newBuilder().setThreadSpecName(threadName).putAllVariables(varAssigns).build();
        String nodeName = this.addNode(threadName, Node.NodeCase.START_THREAD, (Message)startThread);
        WfRunVariableImpl internalStartedThreadVar = this.addVariable(nodeName, (Object)VariableType.INT);
        this.mutate(internalStartedThreadVar, VariableMutationType.ASSIGN, new NodeOutputImpl(nodeName, this));
        return new SpawnedThreadImpl(this, threadName, internalStartedThreadVar);
    }

    public void addTimeoutToExtEvt(NodeOutputImpl node, int timeoutSeconds) {
        this.checkIfIsActive();
        Node.Builder n = this.spec.getNodesOrThrow(node.nodeName).toBuilder();
        if (n.getNodeCase() != Node.NodeCase.EXTERNAL_EVENT) {
            throw new RuntimeException("Tried to set timeout on non-ext evt node!");
        }
        ExternalEventNode.Builder evt = n.getExternalEventBuilder();
        evt.setTimeoutSeconds(VariableAssignment.newBuilder().setLiteralValue(VariableValue.newBuilder().setInt(timeoutSeconds).setType(VariableType.INT)));
        n.setExternalEvent(evt);
        this.spec.putNodes(node.nodeName, n.build());
    }

    @Override
    public void mutate(WfRunVariable lhsVar, VariableMutationType type, Object rhs) {
        this.checkIfIsActive();
        WfRunVariableImpl lhs = (WfRunVariableImpl)lhsVar;
        VariableMutation.Builder mutation = VariableMutation.newBuilder().setLhsName(lhs.name).setOperation(type);
        if (lhs.jsonPath != null) {
            mutation.setLhsJsonPath(lhs.jsonPath);
        }
        if (NodeOutputImpl.class.isAssignableFrom(rhs.getClass())) {
            NodeOutputImpl no = (NodeOutputImpl)rhs;
            if (!no.nodeName.equals(this.lastNodeName)) {
                log.debug("Mutating {} {} {}", new Object[]{no.nodeName, this.lastNodeName, this.name});
                throw new RuntimeException("Cannot use an old NodeOutput from node " + no.nodeName);
            }
            VariableMutation.NodeOutputSource.Builder nodeOutputSource = VariableMutation.NodeOutputSource.newBuilder();
            if (no.jsonPath != null) {
                nodeOutputSource.setJsonpath(no.jsonPath);
            }
            mutation.setNodeOutput(nodeOutputSource);
        } else if (WfRunVariableImpl.class.isAssignableFrom(rhs.getClass())) {
            WfRunVariableImpl var = (WfRunVariableImpl)rhs;
            VariableAssignment.Builder varBuilder = VariableAssignment.newBuilder();
            if (var.jsonPath != null) {
                varBuilder.setJsonPath(var.jsonPath);
            }
            varBuilder.setVariableName(var.name);
            mutation.setSourceVariable(varBuilder);
        } else {
            VariableValue rhsVal;
            try {
                rhsVal = LHLibUtil.objToVarVal(rhs);
            }
            catch (LHSerdeError exn) {
                throw new RuntimeException(exn);
            }
            mutation.setLiteralValue(rhsVal);
        }
        this.addMutationToCurrentNode(mutation.build());
    }

    @Override
    public WaitForThreadsNodeOutput waitForThreads(SpawnedThread ... threadsToWaitFor) {
        this.checkIfIsActive();
        WaitForThreadsNode.Builder waitNode = WaitForThreadsNode.newBuilder();
        for (int i = 0; i < threadsToWaitFor.length; ++i) {
            SpawnedThreadImpl st = (SpawnedThreadImpl)threadsToWaitFor[i];
            waitNode.addThreads(WaitForThreadsNode.ThreadToWaitFor.newBuilder().setThreadRunNumber(this.assignVariable(st.internalThreadVar)));
        }
        waitNode.setPolicy(WaitForThreadsPolicy.STOP_ON_FAILURE);
        String nodeName = this.addNode("threads", Node.NodeCase.WAIT_FOR_THREADS, (Message)waitNode.build());
        return new WaitForThreadsNodeOutputImpl(nodeName, this, this.spec);
    }

    @Override
    public WaitForThreadsNodeOutput waitForThreads(SpawnedThreads threads) {
        this.checkIfIsActive();
        WaitForThreadsNode.Builder waitNode = WaitForThreadsNode.newBuilder();
        SpawnedThreadsImpl spawnedThreads = (SpawnedThreadsImpl)threads;
        waitNode.setThreadList(this.assignVariable(spawnedThreads.getInternalThreadVar()));
        waitNode.setPolicy(WaitForThreadsPolicy.STOP_ON_FAILURE);
        String nodeName = this.addNode("threads", Node.NodeCase.WAIT_FOR_THREADS, (Message)waitNode.build());
        return new WaitForThreadsNodeOutputImpl(nodeName, this, this.spec);
    }

    @Override
    public NodeOutputImpl waitForEvent(String externalEventDefName) {
        this.checkIfIsActive();
        ExternalEventNode waitNode = ExternalEventNode.newBuilder().setExternalEventDefName(externalEventDefName).build();
        this.parent.addExternalEventDefName(externalEventDefName);
        return new NodeOutputImpl(this.addNode(externalEventDefName, Node.NodeCase.EXTERNAL_EVENT, (Message)waitNode), this);
    }

    @Override
    public void complete() {
        this.checkIfIsActive();
        ExitNode exitNode = ExitNode.newBuilder().build();
        this.addNode("complete", Node.NodeCase.EXIT, (Message)exitNode);
    }

    @Override
    public void fail(String failureName, String message) {
        this.fail(null, failureName, message);
    }

    @Override
    public void fail(Object output, String failureName, String message) {
        this.checkIfIsActive();
        FailureDef.Builder failureBuilder = FailureDef.newBuilder();
        if (output != null) {
            failureBuilder.setContent(this.assignVariable(output));
        }
        if (message != null) {
            failureBuilder.setMessage(message);
        }
        failureBuilder.setFailureName(failureName);
        ExitNode exitNode = ExitNode.newBuilder().setFailureDef(failureBuilder).build();
        this.addNode(failureName, Node.NodeCase.EXIT, (Message)exitNode);
    }

    @Override
    public void registerInterruptHandler(String interruptName, ThreadFunc handler) {
        this.checkIfIsActive();
        Object threadName = "interrupt-" + interruptName;
        threadName = this.parent.addSubThread((String)threadName, handler);
        this.parent.addExternalEventDefName(interruptName);
        this.spec.addInterruptDefs(InterruptDef.newBuilder().setExternalEventDefName(interruptName).setHandlerSpecName((String)threadName).build());
    }

    @Override
    public void handleException(NodeOutput nodeOutput, String exceptionName, ThreadFunc handler) {
        this.addExceptionHandler(nodeOutput, exceptionName, handler);
    }

    @Override
    public void handleException(NodeOutput node, ThreadFunc handler) {
        this.addExceptionHandler(node, null, handler);
    }

    @Override
    public void handleError(NodeOutput node, LHErrorType error, ThreadFunc handler) {
        this.addErrorHandler(node, error, handler);
    }

    @Override
    public void handleError(NodeOutput node, ThreadFunc handler) {
        this.addErrorHandler(node, null, handler);
    }

    @Override
    public void handleAnyFailure(NodeOutput nodeOutput, ThreadFunc handler) {
        this.checkIfIsActive();
        NodeOutputImpl node = (NodeOutputImpl)nodeOutput;
        Object threadName = "exn-handler-" + node.nodeName + "-any-failure";
        threadName = this.parent.addSubThread((String)threadName, handler);
        FailureHandlerDef.Builder handlerDef = FailureHandlerDef.newBuilder().setHandlerSpecName((String)threadName);
        this.addFailureHandlerDef(handlerDef.build(), node);
    }

    private void addFailureHandlerDef(FailureHandlerDef handlerDef, NodeOutputImpl node) {
        Node.Builder lastNodeBuilder = this.spec.getNodesOrThrow(node.nodeName).toBuilder();
        lastNodeBuilder.addFailureHandlers(handlerDef);
        this.spec.putNodes(node.nodeName, lastNodeBuilder.build());
    }

    private void addExceptionHandler(NodeOutput nodeOutput, String exceptionName, ThreadFunc handler) {
        this.checkIfIsActive();
        NodeOutputImpl node = (NodeOutputImpl)nodeOutput;
        Object threadName = "exn-handler-" + node.nodeName + "-" + exceptionName;
        threadName = this.parent.addSubThread((String)threadName, handler);
        FailureHandlerDef.Builder handlerDef = FailureHandlerDef.newBuilder().setHandlerSpecName((String)threadName);
        if (exceptionName != null) {
            handlerDef.setSpecificFailure(exceptionName);
        } else {
            handlerDef.setAnyFailureOfType(FailureHandlerDef.LHFailureType.FAILURE_TYPE_EXCEPTION);
        }
        this.addFailureHandlerDef(handlerDef.build(), node);
    }

    private void addErrorHandler(NodeOutput nodeOutput, LHErrorType errorType, ThreadFunc handler) {
        this.checkIfIsActive();
        NodeOutputImpl node = (NodeOutputImpl)nodeOutput;
        Object threadName = "exn-handler-" + node.nodeName + "-" + (Serializable)(errorType != null ? errorType.getInternalName() : FailureHandlerDef.LHFailureType.FAILURE_TYPE_ERROR);
        threadName = this.parent.addSubThread((String)threadName, handler);
        FailureHandlerDef.Builder handlerDef = FailureHandlerDef.newBuilder().setHandlerSpecName((String)threadName);
        if (errorType != null) {
            handlerDef.setSpecificFailure(errorType.getInternalName());
        } else {
            handlerDef.setAnyFailureOfType(FailureHandlerDef.LHFailureType.FAILURE_TYPE_ERROR);
        }
        this.addFailureHandlerDef(handlerDef.build(), node);
    }

    @Override
    public WorkflowConditionImpl condition(Object lhs, Comparator comparator, Object rhs) {
        EdgeCondition.Builder edge = EdgeCondition.newBuilder().setComparator(comparator).setLeft(this.assignVariable(lhs)).setRight(this.assignVariable(rhs));
        return new WorkflowConditionImpl(edge.build());
    }

    private String addNode(String name, Node.NodeCase type, Message subNode) {
        this.checkIfIsActive();
        String nextNodeName = this.getNodeName(name, type);
        if (this.lastNodeName == null) {
            throw new RuntimeException("Not possible to have null last node here");
        }
        Node.Builder feederNode = this.spec.getNodesOrThrow(this.lastNodeName).toBuilder();
        Edge.Builder edge = Edge.newBuilder().setSinkNodeName(nextNodeName);
        if (this.lastNodeCondition != null) {
            edge.setCondition(this.lastNodeCondition);
            this.lastNodeCondition = null;
        }
        if (feederNode.getNodeCase() != Node.NodeCase.EXIT) {
            feederNode.addOutgoingEdges(edge);
            this.spec.putNodes(this.lastNodeName, feederNode.build());
        }
        Node.Builder node = Node.newBuilder();
        switch (type) {
            case TASK: {
                node.setTask((TaskNode)subNode);
                break;
            }
            case ENTRYPOINT: {
                node.setEntrypoint((EntrypointNode)subNode);
                break;
            }
            case EXIT: {
                node.setExit((ExitNode)subNode);
                break;
            }
            case EXTERNAL_EVENT: {
                node.setExternalEvent((ExternalEventNode)subNode);
                break;
            }
            case SLEEP: {
                node.setSleep((SleepNode)subNode);
                break;
            }
            case START_THREAD: {
                node.setStartThread((StartThreadNode)subNode);
                break;
            }
            case WAIT_FOR_THREADS: {
                node.setWaitForThreads((WaitForThreadsNode)subNode);
                break;
            }
            case NOP: {
                node.setNop((NopNode)subNode);
                break;
            }
            case USER_TASK: {
                node.setUserTask((UserTaskNode)subNode);
                break;
            }
            case START_MULTIPLE_THREADS: {
                node.setStartMultipleThreads((StartMultipleThreadsNode)subNode);
                break;
            }
            case NODE_NOT_SET: {
                throw new RuntimeException("Not possible");
            }
        }
        this.spec.putNodes(nextNodeName, node.build());
        this.lastNodeName = nextNodeName;
        return nextNodeName;
    }

    private String getNodeName(String name, Node.NodeCase type) {
        return this.spec.getNodesCount() + "-" + name + "-" + type;
    }

    public VariableAssignment assignVariable(Object variable) {
        this.checkIfIsActive();
        VariableAssignment.Builder builder = VariableAssignment.newBuilder();
        if (variable == null) {
            builder.setLiteralValue(VariableValue.newBuilder().setType(VariableType.NULL));
        } else if (variable.getClass().equals(WfRunVariableImpl.class)) {
            WfRunVariableImpl wrv = (WfRunVariableImpl)variable;
            if (wrv.jsonPath != null) {
                builder.setJsonPath(wrv.jsonPath);
            }
            builder.setVariableName(wrv.name);
        } else {
            if (variable.getClass().equals(NodeOutputImpl.class)) {
                throw new RuntimeException("Error: Cannot use NodeOutput directly as input to task. First save to a WfRunVariable.");
            }
            if (variable.getClass().equals(LHFormatStringImpl.class)) {
                LHFormatStringImpl format = (LHFormatStringImpl)variable;
                builder.setFormatString(VariableAssignment.FormatString.newBuilder().setFormat(this.assignVariable(format.getFormat())).addAllArgs(format.getArgs()));
            } else {
                try {
                    VariableValue defVal = LHLibUtil.objToVarVal(variable);
                    builder.setLiteralValue(defVal);
                }
                catch (LHSerdeError exn) {
                    throw new RuntimeException(exn);
                }
            }
        }
        return builder.build();
    }

    private void checkIfIsActive() {
        if (!this.isActive) {
            throw new RuntimeException("Using a inactive thread");
        }
    }

    public WorkflowImpl getParent() {
        return this.parent;
    }

    public List<WfRunVariableImpl> getWfRunVariables() {
        return this.wfRunVariables;
    }

    public String getLastNodeName() {
        return this.lastNodeName;
    }

    public String getName() {
        return this.name;
    }

    public EdgeCondition getLastNodeCondition() {
        return this.lastNodeCondition;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setParent(WorkflowImpl parent) {
        this.parent = parent;
    }

    public void setSpec(ThreadSpec.Builder spec) {
        this.spec = spec;
    }

    public void setWfRunVariables(List<WfRunVariableImpl> wfRunVariables) {
        this.wfRunVariables = wfRunVariables;
    }

    public void setLastNodeName(String lastNodeName) {
        this.lastNodeName = lastNodeName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLastNodeCondition(EdgeCondition lastNodeCondition) {
        this.lastNodeCondition = lastNodeCondition;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }
}

