/*
 * Decompiled with CFR 0.152.
 */
package io.littlehorse.sdk.common.config;

import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.Grpc;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.TlsChannelCredentials;
import io.littlehorse.sdk.common.auth.OAuthClient;
import io.littlehorse.sdk.common.auth.OAuthConfig;
import io.littlehorse.sdk.common.auth.OAuthCredentialsProvider;
import io.littlehorse.sdk.common.config.ConfigBase;
import io.littlehorse.sdk.common.proto.LHPublicApiGrpc;
import io.littlehorse.sdk.common.proto.TaskDef;
import io.littlehorse.sdk.common.proto.TaskDefId;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LHConfig
extends ConfigBase {
    private static final Logger log = LoggerFactory.getLogger(LHConfig.class);
    public static final String API_HOST_KEY = "LHC_API_HOST";
    public static final String API_PORT_KEY = "LHC_API_PORT";
    public static final String CLIENT_ID_KEY = "LHC_CLIENT_ID";
    public static final String CLIENT_CERT_KEY = "LHC_CLIENT_CERT";
    public static final String CLIENT_KEY_KEY = "LHC_CLIENT_KEY";
    public static final String CA_CERT_KEY = "LHC_CA_CERT";
    public static final String OAUTH_CLIENT_ID_KEY = "LHC_OAUTH_CLIENT_ID";
    public static final String OAUTH_CLIENT_SECRET_KEY = "LHC_OAUTH_CLIENT_SECRET";
    public static final String OAUTH_ACCESS_TOKEN_URL = "LHC_OAUTH_ACCESS_TOKEN_URL";
    public static final String NUM_WORKER_THREADS_KEY = "LHW_NUM_WORKER_THREADS";
    public static final String SERVER_CONNECT_LISTENER_KEY = "LHW_SERVER_CONNECT_LISTENER";
    public static final String TASK_WORKER_VERSION_KEY = "LHW_TASK_WORKER_VERSION";
    public static final String DEFAULT_PUBLIC_LISTENER = "PLAIN";
    private static final Set<String> configNames = Collections.unmodifiableSet(Set.of("LHC_API_HOST", "LHC_API_PORT", "LHC_CLIENT_ID", "LHC_CLIENT_CERT", "LHC_CLIENT_KEY", "LHC_CA_CERT", "LHC_OAUTH_ACCESS_TOKEN_URL", "LHC_OAUTH_CLIENT_ID", "LHC_OAUTH_CLIENT_SECRET", "LHW_NUM_WORKER_THREADS", "LHW_SERVER_CONNECT_LISTENER", "LHW_TASK_WORKER_VERSION"));
    private Map<String, Channel> createdChannels = new HashMap<String, Channel>();
    private OAuthClient oauthClient;
    private OAuthConfig oauthConfig;
    private OAuthCredentialsProvider oauthCredentialsProvider;

    public static Set<String> configNames() {
        return configNames;
    }

    public LHConfig() {
    }

    public LHConfig(Properties props) {
        super(props);
    }

    public LHConfig(String propLocation) {
        super(propLocation);
    }

    public LHConfig(Map<String, Object> configs) {
        super(configs);
    }

    public LHPublicApiGrpc.LHPublicApiBlockingStub getBlockingStub() throws IOException {
        return this.getBlockingStub(this.getApiBootstrapHost(), this.getApiBootstrapPort());
    }

    public LHPublicApiGrpc.LHPublicApiStub getAsyncStub() throws IOException {
        return this.getAsyncStub(this.getApiBootstrapHost(), this.getApiBootstrapPort());
    }

    public TaskDef getTaskDef(String taskDefName) throws IOException {
        return this.getBlockingStub().getTaskDef(TaskDefId.newBuilder().setName(taskDefName).build());
    }

    public String getTaskWorkerVersion() {
        return this.getOrSetDefault(TASK_WORKER_VERSION_KEY, "");
    }

    public String getConnectListener() {
        return this.getOrSetDefault(SERVER_CONNECT_LISTENER_KEY, DEFAULT_PUBLIC_LISTENER);
    }

    public LHPublicApiGrpc.LHPublicApiStub getAsyncStub(String host, int port) throws IOException {
        if (this.isOauth()) {
            return (LHPublicApiGrpc.LHPublicApiStub)LHPublicApiGrpc.newStub(this.getChannel(host, port)).withCallCredentials(this.oauthCredentialsProvider);
        }
        return LHPublicApiGrpc.newStub(this.getChannel(host, port));
    }

    public LHPublicApiGrpc.LHPublicApiBlockingStub getBlockingStub(String host, int port) throws IOException {
        if (this.isOauth()) {
            return (LHPublicApiGrpc.LHPublicApiBlockingStub)LHPublicApiGrpc.newBlockingStub(this.getChannel(host, port)).withCallCredentials(this.oauthCredentialsProvider);
        }
        return LHPublicApiGrpc.newBlockingStub(this.getChannel(host, port));
    }

    private Channel getChannel(String host, int port) throws IOException {
        ManagedChannel out;
        String hostKey = host + ":" + port;
        if (this.createdChannels.containsKey(hostKey)) {
            return this.createdChannels.get(hostKey);
        }
        String caCertFile = this.getOrSetDefault(CA_CERT_KEY, null);
        String clientCertFile = this.getOrSetDefault(CLIENT_CERT_KEY, null);
        String clientKeyFile = this.getOrSetDefault(CLIENT_KEY_KEY, null);
        if (caCertFile == null) {
            log.warn("Using insecure channel!");
            out = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        } else {
            log.info("Using secure connection!");
            TlsChannelCredentials.Builder tlsBuilder = TlsChannelCredentials.newBuilder().trustManager(new File(caCertFile));
            if (clientCertFile != null && clientKeyFile != null) {
                log.info("Using mtls!");
                tlsBuilder.keyManager(new File(clientCertFile), new File(clientKeyFile));
            }
            out = Grpc.newChannelBuilderForAddress((String)host, (int)port, (ChannelCredentials)tlsBuilder.build()).build();
        }
        this.createdChannels.put(hostKey, (Channel)out);
        return out;
    }

    public String getApiBootstrapHost() {
        return this.getOrSetDefault(API_HOST_KEY, "localhost");
    }

    public int getApiBootstrapPort() {
        return Integer.valueOf(this.getOrSetDefault(API_PORT_KEY, "2023"));
    }

    public String getClientId() {
        return this.getOrSetDefault(CLIENT_ID_KEY, "client-" + UUID.randomUUID().toString().replaceAll("-", ""));
    }

    public boolean isOauth() {
        String clientId = this.getOrSetDefault(OAUTH_CLIENT_ID_KEY, null);
        String clientSecret = this.getOrSetDefault(OAUTH_CLIENT_SECRET_KEY, null);
        String tokenEndpointUrl = this.getOrSetDefault(OAUTH_ACCESS_TOKEN_URL, null);
        if (clientId == null && clientSecret == null && tokenEndpointUrl == null) {
            log.info("OAuth is disable");
            return false;
        }
        if (clientId == null || clientSecret == null || tokenEndpointUrl == null) {
            throw new IllegalArgumentException("OAuth Configuration is Missing");
        }
        log.info("OAuth is enable");
        if (this.oauthConfig == null) {
            this.oauthConfig = OAuthConfig.builder().tokenEndpointURI(URI.create(tokenEndpointUrl)).clientId(clientId).clientSecret(clientSecret).build();
        }
        if (this.oauthClient == null) {
            this.oauthClient = new OAuthClient(this.oauthConfig);
        }
        if (this.oauthCredentialsProvider == null) {
            this.oauthCredentialsProvider = new OAuthCredentialsProvider(this.oauthClient);
        }
        log.info("OAuth initialized");
        return true;
    }

    @Override
    protected String[] getEnvKeyPrefixes() {
        return new String[]{"LHC_", "LHW_"};
    }

    public int getWorkerThreads() {
        return Integer.valueOf(this.getOrSetDefault(NUM_WORKER_THREADS_KEY, "8"));
    }
}

